/* -*- mode: c; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 * kdc/policy.c
 *
 * Copyright 1990 by the Massachusetts Institute of Technology.
 *
 * Export of this software from the United States of America may
 *   require a specific license from the United States Government.
 *   It is the responsibility of any person or organization contemplating
 *   export to obtain such a license before exporting.
 *
 * WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of M.I.T. not be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior
 * permission.  Furthermore if you modify this software you must label
 * your software as modified software and not distribute it in such a
 * fashion that it might be confused with the original M.I.T. software.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 *
 * Policy decision routines for KDC.
 */
/*
 * Copyright (c) 2006-2008, Novell, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *   * The copyright holder's name is not used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "k5-int.h"
#include "kdc_util.h"
#include "extern.h"

int
against_local_policy_as(register krb5_kdc_req *request, krb5_db_entry client,
                        krb5_db_entry server, krb5_timestamp kdc_time,
                        const char **status, krb5_data *e_data)
{
    krb5_error_code             code;
    kdb_check_policy_as_req     req;
    kdb_check_policy_as_rep     rep;
    krb5_data                   req_data;
    krb5_data                   rep_data;

#if 0
    /* An AS request must include the addresses field */
    if (request->addresses == 0) {
        *status = "NO ADDRESS";
        return KRB5KDC_ERR_POLICY;
    }
#endif

    memset(&req, 0, sizeof(req));
    memset(&rep, 0, sizeof(rep));

    req.request                 = request;
    req.client                  = &client;
    req.server                  = &server;
    req.kdc_time                = kdc_time;

    req_data.data = (void *)&req;
    req_data.length = sizeof(req);

    rep_data.data = (void *)&rep;
    rep_data.length = sizeof(rep);

    code = krb5_db_invoke(kdc_context,
                          KRB5_KDB_METHOD_CHECK_POLICY_AS,
                          &req_data,
                          &rep_data);
    if (code == KRB5_KDB_DBTYPE_NOSUP)
        return 0;

    *status = rep.status;
    *e_data = rep.e_data;

    if (code != 0) {
        code -= ERROR_TABLE_BASE_krb5;
        if (code < 0 || code > 128)
            code = KRB_ERR_GENERIC;
    }

    return code;
}

/*
 * This is where local policy restrictions for the TGS should placed.
 */
krb5_error_code
against_local_policy_tgs(register krb5_kdc_req *request, krb5_db_entry server,
                         krb5_ticket *ticket, const char **status,
                         krb5_data *e_data)
{
    krb5_error_code             code;
    kdb_check_policy_tgs_req    req;
    kdb_check_policy_tgs_rep    rep;
    krb5_data                   req_data;
    krb5_data                   rep_data;

#if 0
    /*
     * For example, if your site wants to disallow ticket forwarding,
     * you might do something like this:
     */

    if (isflagset(request->kdc_options, KDC_OPT_FORWARDED)) {
        *status = "FORWARD POLICY";
        return KRB5KDC_ERR_POLICY;
    }
#endif

    memset(&req, 0, sizeof(req));
    memset(&rep, 0, sizeof(rep));

    req.request                 = request;
    req.server                  = &server;
    req.ticket                  = ticket;

    req_data.data = (void *)&req;
    req_data.length = sizeof(req);

    rep_data.data = (void *)&rep;
    rep_data.length = sizeof(rep);

    code = krb5_db_invoke(kdc_context,
                          KRB5_KDB_METHOD_CHECK_POLICY_TGS,
                          &req_data,
                          &rep_data);
    if (code == KRB5_KDB_DBTYPE_NOSUP)
        return 0;

    *status = rep.status;
    *e_data = rep.e_data;

    if (code != 0) {
        code -= ERROR_TABLE_BASE_krb5;
        if (code < 0 || code > 128)
            code = KRB_ERR_GENERIC;
    }

    return code;
}
