      subroutine collision

      implicit none
      include 'mc.inc'

      integer number, nsel
      integer ip1, ip2
      integer k1,k2

      real cos_th, sin_th, phi
      real select, vrm ,vr
      real vcm(3)
      real vrel(3)
      
      col = 0                         ! Count number of collisions

      do j=1,ncell                    ! Loop over cells

       number = celln(j)              ! Number of particles in cell j

       if(number.gt.1) then           ! Skip cells with 1 particle

        select = coeff*number**2*vrmax(j) + selxtra(j)
        nsel = int(select)            ! Number of pairs to be selected
        selxtra(j) = select-nsel      ! Carry over any left-over fraction
        vrm = vrmax(j)                ! Current maximum relative speed

        do i=1,nsel                   ! Loop over total candidate collision pairs

          k1 = int(ran2(seed)*number) ! Pick two random particles
          k2 = mod(int(k1+ran2(seed)*(number-1))+1, number)

          ip1 = xref(k1+index(j))      ! First particle
          ip2 = xref(k2+index(j))      ! Second particle

          vr = sqrt( (v(ip1,1)-v(ip2,1))**2 +   ! Relative speed
     &               (v(ip1,2)-v(ip2,2))**2 +
     &               (v(ip1,3)-v(ip2,3))**2 )

          if( vr .gt. vrm ) then    ! If relative speed larger than vrm,
            vrm = vr                ! then reset vrm to larger value
          endif

          if(vr/vrmax(j).gt.ran2(seed)) then        ! Accept candidate for collision

            col = col + 1                           ! Collision counter

            do k=1,3
              vcm(k) = 0.5*(v(ip1,k) + v(ip2,k))    ! Center of mass velocity
            enddo

            cos_th  = 1.0 - 2.0*ran2(seed)          ! Cosine and sine of
            sin_th  = sqrt(1.0 - cos_th**2)         ! collision angle theta
            phi     = 2.0*pi*ran2(seed)             ! Collision angle phi
            vrel(1) = vr*cos_th                     ! Compute post-collision
            vrel(2) = vr*sin_th*cos(phi)            ! relative velocity
            vrel(3) = vr*sin_th*sin(phi)

            do  k=1,3
              v(ip1,k) = vcm(k) + 0.5*vrel(k)   ! Update post-collision
              v(ip2,k) = vcm(k) - 0.5*vrel(k)   ! velocities
            enddo

          endif

          vrmax(j) = vrm                        ! Update max relative speed

        enddo   ! Loop over pairs
       endif
      enddo   ! Loop over cells

      return
      end
