% do_run.m

% This script does a run of mc2 and stores most relevant information
% regarding the run into the structure run_data.  The run can take
% quite awhile, so have patience.

% Set gas parameters [Have to be changed in the fortran program if
% changed here]

  boltz = 1.3806e-23;
  mass  = 6.63e-26;
  diam  = 3.66e-10;
  T     = 273.0;
  density = 2.685e25;

  mfp = 1/(sqrt(2)*pi*diam^2*density);
  vmp = sqrt(2*boltz*T/mass);

% Set input parameters

  system_dimension   = 1e-6;  % in meters; 1e-6m = 1 micron (keep small)
  total_cells        = 200;
  particles_per_cell = 50;    % at most 1e5 particles total
  tau_factor         = 0.5;
  num_steps          = 40000;
  wall_mach_no       = 0.05;
  right_wall_temp    = 273;
  left_wall_temp     = 273;
  x_pressure_loc     = 0.5;
  
% Time step
 
  time_step = tau_factor*(system_dimension/total_cells)/vmp;
   
% Print parameters to input_data.txt
  fid = fopen('input_data.txt','w');
  fprintf(fid,'%.12f\n',system_dimension);
  fprintf(fid,'%d\n',total_cells); 
  fprintf(fid,'%d\n',particles_per_cell);
  fprintf(fid,'%f\n',tau_factor);
  fprintf(fid,'%d\n',num_steps);
  fprintf(fid,'%.12f\n',wall_mach_no);
  fprintf(fid,'%.12f\n',right_wall_temp);
  fprintf(fid,'%.12f\n',left_wall_temp);
  fprintf(fid,'%.12f\n',x_pressure_loc);
  fclose(fid);

% Run the program
  disp(['Running program (this could take some time)...']);
  !./mc2 < input_data.txt | tee output_data.txt
  disp(['Reading output.']);
  !head -n 12 output_data.txt | tail -n 5 > out1.txt
  !tail -10 output_data.txt > out2.txt
  !cat out1.txt out2.txt >! output_data2.txt
  !rm -f out1.txt out2.txt
  
% Parse the output data
  run_data = load_data; 
  info_str = urlread(['file://' pwd '/output_data2.txt']);
  run_data.info_str = info_str;

% Save the input parameters
  run_data.input.system_dimension =   system_dimension;
  run_data.input.total_cells        = total_cells;
  run_data.input.particles_per_cell = particles_per_cell;
  run_data.input.tau_factor         = tau_factor;
  run_data.input.num_steps          = num_steps;
  run_data.input.wall_mach_no       = wall_mach_no;
  run_data.input.right_wall_temp    = right_wall_temp;
  run_data.input.left_wall_temp     = left_wall_temp;
  run_data.input.x_pressure_loc     = x_pressure_loc;

  disp(['Done.']);




