      subroutine initial
      
      implicit none
      include 'mc.inc'

      integer ppcell
      double precision taufactor

      pi    = 4.0*atan(1.0)
      boltz = 1.3806d-23
      mass  = 6.63d-26
      diam  = 3.66d-10
      T     = 273.0
      density = 2.685d25

      mfp   = 1.0/(sqrt(2.0)*pi*diam**2*density)

      write(*,*) 'Enter system dimension (m)'
      read(*,*) L

      volume  = L*L*L  
      vmp    = sqrt(2*boltz*T/mass)
      nsamp  = 0
      tsamp  = 0.0                        
          
      dvtot(1) = 0.0      
      dvtot(2) = 0.0
      dutot(1) = 0.0
      dutot(2) = 0.0
      presstot = 0.0
  
  
      write(*,*) 'Enter TOTAL number of cells'
      read(*,*) ncell

      write(*,*) 'Enter number of particles per cell'
      write(*,*) 'Rule-of-thumb says you need at least 20'
      read(*,*) ppcell

      npart = ncell*ppcell       ! Total no. of particles
      neff  = density*L**3/npart ! No. of atoms per particle      

      if (npart.gt.real(NMAX)) then
        write(*,*) 'Too many particles! Decrease one of the above &
     & quantities'
        stop
      endif

      write(*,*) 'Enter time step as a fraction of mean collision time'
      write(*,*) 'This must be between 0.0 and 1.0'
      read(*,*) taufactor     
 
      tau    = taufactor*(L/ncell)/vmp

      write(*,*) 'Effective number (no. of atoms/particle) = ', neff
      write(*,*) 'Mean free path (m) = ',mfp     
      write(*,*) 'Knudsen Number [Mean free path/L] = ',mfp/L
      write(*,*) 'Number of cells = ',ncell
      write(*,*) 'Number of particle = ',npart
      write(*,*) 'Time step (sec) = ',tau

      write(*,*) 'Enter no. of time steps'
      read(*,*) nsteps
             
      write(*,*) 'Enter wall Mach number.'
      write(*,*) 'Mach no. = wall velocity / speed of sound'
      write(*,*) 'This code assumes walls move at +/- wall Mach no.'
      read(*,*) vwall

      write(*,*) 'Enter temperature of right hand side wall (K)'
      read(*,*) tempr

      write(*,*) 'Enter temperature of left hand side wall (K)'
      read(*,*) templ
     
      write(*,*) 'Enter x-plane at which to calculate pressure'
      write(*,*) 'Note this will calculate at xplane*L'
      read(*,*) xplane

      xplane = xplane*L

      vmpw(1) = sqrt(2*boltz*templ/mass)
      vmpw(2) = sqrt(2*boltz*tempr/mass)

      vwall = vwall * sqrt(5./3. * boltz*T/mass)
      write(*,*) 'Wall velocities are ', -vwall, ' m/s and',
     &                                    vwall, ' m/s'

c     Assign random positions and velocities to particles
     
      seed = 1

      do i=1,npart
        x(i) = L*ran2(seed)
        T = x(i)/L*tempr + (1.0-x(i)/L)*templ
        v(i,1) = sqrt(boltz*T/mass) * randn(seed)
        v(i,2) = sqrt(boltz*T/mass) * randn(seed)
        v(i,3) = sqrt(boltz*T/mass) * randn(seed)
        v(i,2) = v(i,2) + vwall * 2*(x(i)/L - 0.5)        
      enddo

c     Initialize cell quantitities
      do i=1,ncell
         vrmax(i) = 3*vmp
         selxtra(i) = 0.0
      enddo
            
      coeff = 0.5*neff*pi*diam**2*tau/(L**3/ncell)

      !* Initialize object and variables used in statistical sampling

      do i=1,ncell
        ave_n(i)  = 0.0
        ave_ux(i) = 0.0
        ave_uy(i) = 0.0
        ave_uz(i) = 0.0
        ave_T(i)  = 0.0
      enddo

      return
      end










