c----------------------------------------------
c  Include file for '2D MonteCarlo Simulations'
c
c  Contains Common Block
c
c  Sanith W				14Feb00
c----------------------------------------------

c	Problem dimension size

	integer NMAX
        integer CMAX
	parameter( NMAX=100000, CMAX=100000)

c	Gas constants

	real boltz		! Boltzmann constant (J/K)
	real mass           ! Mass of atom (Kg)
	real diam		! Diameter of atom (m)
	real T		! Temperature (K)
	real density        ! Number density of gas at STP (/m^3)
	real L              ! System size (m)
	real vmp		! Most probable speed (m/s)
        real vmpw(2)        ! Most probable speed at wall (m/s)
        real mfp		! Mean free path                	

c	Simulation constants

	integer nsteps		! No. of time steps
	integer npart			! No. of particles
	integer ncell			! Number of cells
 	real tau		! Time step
        real tsamp		! Total time of sampling
        integer col             	! Current collision no.
	integer coltot		! Total collisions
        real volume   	! Cell volume
        real tempr		! Temperature of right wall
	real templ		! Temperature of left wall

c       Forces

        real force_xy(2)        ! Wall shear stress
        real force_xx(2)        ! Wall pressure
        real press              ! Pressure at x-plane (user-defined)
        real presstot           ! Cumulative pressure at x-plane
        real xplane             ! x-plane at which to calculate pressure
        real delv(2)            ! Change in y-momentum 
        real delu(2)            ! Change in x-momentum
        real dvtot(2)           ! Cumulative change in y-momentum
        real dutot(2)           ! Cumulative change in x-momentum
        

c	Statistics

	real sum_n(CMAX)
	real sum_vx(CMAX)
        real sum_vy(CMAX)
        real sum_vz(CMAX)
        real sum_v2(CMAX)

	real ave_n(CMAX)
	real ave_ux(CMAX)
        real ave_uy(CMAX)
	real ave_uz(CMAX)
	real ave_T(CMAX)

        integer strikes(2)
        integer strikeSum(2)

	integer nsamp

c	Other

	real x(NMAX)
        integer xref(NMAX)                ! Particles arranges in increasing x
        integer celln(CMAX)               ! No. of particles in each cell
	integer index(CMAX)               ! Cumulative sum of particles in each cell
        real neff               ! Effective number
        real coeff              ! Constant terms in total collisions reqd.
        real selxtra(CMAX)      ! Left over from no. of collisions reqd.
	real v(NMAX,3)          ! Particle velocity vector
        real vgrad	      	    ! Velocity gradient	
        real visc		    ! Viscosity
        real vold(NMAX,3)       ! Store old velocity vector
        real xold(NMAX)         ! Store old x-coordinate 
        real vmagI(NMAX)        ! Initial speed distribution
        real vmagF(NMAX)        ! Final speed distribution       
        real vrmax(CMAX)
        real vwall		    ! Wall velocity
	real pi

c	Indices
	
	integer i,j,k,m,n,q

c       Random number
     
        integer seed
        real randn, ran2

c
c	Common Declarations
c

	common/main/
     &  ave_n
     & ,ave_ux
     & ,ave_uy
     & ,ave_uz
     & ,ave_T
     & ,boltz	
     & ,celln
     & ,coeff
     & ,col
     & ,coltot	
     & ,delu
     & ,delv
     & ,dutot
     & ,dvtot
     & ,density
     & ,diam		
     & ,force_xx
     & ,force_xy
     & ,index
     & ,L		
     & ,mass
     & ,mfp
     & ,ncell
     & ,neff
     & ,npart  	
     & ,nsamp
     & ,nsteps
     & ,pi
     & ,press
     & ,presstot
     & ,seed
     & ,selxtra
     & ,strikes
     & ,strikeSum
     & ,sum_n
     & ,sum_vx
     & ,sum_vy
     & ,sum_vz
     & ,sum_v2
     & ,T
     & ,tau
     & ,templ
     & ,tempr
     & ,tsamp
     & ,v
     & ,vmp
     & ,vmpw
     & ,vgrad
     & ,visc
     & ,vmagF
     & ,vmagI
     & ,vold
     & ,volume
     & ,vrmax
     & ,vwall
     & ,x
     & ,xold
     & ,xplane
     & ,xref





