      program mc2
      
c--------------------------------------------------------
c  Direct Simulation Monte Carlo 
c
c  Notes:
c  o Only the x coordinate direction is tracked in this
c    program. As such cells are created only along the
c    x direction.
c
c  o Velocity (using Mach no.) and temperature boundary 
c    conditions can be specified on the left and right walls. 
c    - Currently the wall velocities are set to -V and +V to
c      simulate a Couette flow.
c     
c  o This program is based on the DSMC method described in:
c    Garcia, A.L., Numerical Methods for Physics, 2nd edition, 
c    Prentice Hall, NJ, 2000.
c
c  o http://www.algarcia.org/nummeth/nummeth.html has sample
c    dsmc codes that you may want to look at.
c  
c
c  --------
c  Revision History:
c  03/25/00: Added checks in randn.f and mover.f
c            to avoid infinity values in logarithmic
c            expressions
c  03/29/00: Now uses ran2.f random number generator
c            from Numerical Recipes
c  
c  04/02/00: Can now do Temperature Couette
c
c --------
c Sanith W                             01APR00    
c--------------------------------------------------------

      IMPLICIT NONE
      include 'mc.inc'

      open(11,file='xcell.txt' ,status='unknown')
      open(12,file='ave_n.txt' ,status='unknown')
      open(13,file='ave_ux.txt',status='unknown')
      open(14,file='ave_uy.txt',status='unknown')
      open(15,file='ave_uz.txt',status='unknown')
      open(16,file='ave_T.txt' ,status='unknown')
      open(17,file='vel.txt'   ,status='unknown')

c
c------Initialize
c
      call initial

      do i=1,npart           ! Store initial particle speeds
        vmagI(i) = sqrt( v(i,1)**2 + v(i,2)**2 + v(i,3)**2 )
      enddo

c
c------Main Loop Begin
c
      do m=1,nsteps

        delv(1) = 0.0
        delv(2) = 0.0
        delu(1) = 0.0
        delu(2) = 0.0

        call mover             ! Advection step + wall collisions

        strikeSum(1) = strikeSum(1) + strikes(1)
        strikeSum(2) = strikeSum(2) + strikes(2)

        call sort              ! Sort particles in cells
        call collision         ! Evaluate collisions
  
        if(m .gt. nsteps/10) then
          call sampler
          call pressure
          dvtot(1) = dvtot(1) + delv(1)
          dvtot(2) = dvtot(2) + delv(2)
          dutot(1) = dutot(1) + delu(1)
          dutot(2) = dutot(2) + delu(2)    
          presstot  = presstot + press
          tsamp = tsamp + tau
        endif  
           
        coltot = coltot + col       
        
        if( mod(m,100) .lt. 1 ) then 
          write(*,*) 'Done ', m, ' of ', nsteps, ' steps; ',
     &                coltot, ' collisions'
          
          write(*,*) 'Total wall strikes: ', strikeSum(1), ' (left) ',
     &                 strikeSum(2), ' (right)'

        endif      
 
      enddo

      do i=1,ncell
        ave_n(i)  = ave_n(i)*(neff/(volume/ncell))/nsamp
        ave_ux(i) = ave_ux(i)/nsamp
        ave_uy(i) = ave_uy(i)/nsamp
        ave_uz(i) = ave_uz(i)/nsamp
        ave_T(i)  = ave_T(i)/nsamp
        ave_T(i)  = ave_T(i) - ave_ux(i)**2 -ave_uy(i)**2 - ave_uz(i)**2
        ave_T(i)  = ave_T(i) * mass/(3*boltz)
      enddo

c
c------Calculate shear stress, pressure and viscosity
c
      force_xy(1) = (neff*mass*dvtot(1))/(tsamp*L**2)
      force_xy(2) = (neff*mass*dvtot(2))/(tsamp*L**2)
      force_xx(1) = (neff*mass*dutot(1))/(tsamp*L**2)
      force_xx(2) = (neff*mass*dutot(2))/(tsamp*L**2)      

      write(*,*) 'Wall shear stress (N/m^2):'
      write(*,*) 'Left wall:  ', force_xy(1)
      write(*,*) 'Right wall: ', force_xy(2)
      write(*,*) 'Wall pressure (N/m^2):'
      write(*,*) 'Left wall:  ', force_xx(1)
      write(*,*) 'Right wall: ', force_xx(2)
      write(*,*) 'Pressure @ x/L=', xplane/L, ' is',presstot/(tsamp/tau)
 
      vgrad = 2*vwall/L                            ! Velocity gradient
 
      if (vgrad.ne.0.0) then
      visc = 0.5*(force_xy(2)-force_xy(1))/vgrad  ! Average viscosity      
      endif

      write(*,*) 'Viscosity = ', visc
      write(*,*) 'Actual Viscosity = ',
     +                      5.*pi/32.*mass*density*(2./sqrt(pi)*vmp)*mfp      
c
c------Output Results
c                                           
      do i=1,ncell
        write(11,*) (i-0.5)*L/ncell
        write(12,*) ave_n(i)
        write(13,*) ave_ux(i)
        write(14,*) ave_uy(i)
        write(15,*) ave_uz(i)
        write(16,*) ave_T(i)
      enddo

      do i=1,npart           ! Final distribution of particle speeds   
        vmagF(i) = sqrt( v(i,1)**2 + v(i,2)**2 + v(i,3)**2 )
        write(17,*) vmagI(i), vmagF(i)
      enddo

      stop
      end

!***** To plot in MATLAB; use the script below ********************
!load xcell.txt;  load ave_n.txt;     load ave_ux.txt;
!load ave_uy.txt; load ave_uz.txt;    load ave_T.txt;
!figure(1); clf;
!plot(xcell,ave_n); xlabel('position');  ylabel('Number density');
!figure(2); clf;
!plot(xcell,ave_ux,xcell,ave_uy,xcell,ave_uz);
!xlabel('position');  ylabel('Velocities');
!legend('x-component','y-component','z-component');
!figure(3); clf;
!plot(xcell,ave_T); xlabel('position');  ylabel('Temperature');
!******************************************************************


