      subroutine mover
      
      implicit none
      include 'mc.inc'

      integer direction(2)
      integer flag
      real xwall(2), vw(2), stdev(2), dtr, vyInitial, vxInitial
      real trial

      do i=1,npart                  ! Move all particles
         xold(i) = x(i)
         x(i) = xold(i) + v(i,1)*tau
      enddo

      strikes(1) = 0                ! Check if particle strikes wall
      strikes(2) = 0
      delv(1) = 0.0
      delv(2) = 0.0
      delu(1) = 0.0
      delu(2) = 0.0
      xwall(1) = 0
      xwall(2) = L                  ! Positions of walls
      vw(1) = -vwall
      vw(2) = vwall                 ! Velocities of walls
      stdev(1) = vmpw(1)/sqrt(2.0)
      stdev(2) = vmpw(2)/sqrt(2.0)

      direction(1) = 1
      direction(2) = -1             ! Direction of particle leaving wall

      do i=1,npart

        flag = 0
        if(x(i).le.0) then
          flag=1                    ! Particle strikes left wall
        else if(x(i).ge.L) then
          flag=2                    ! Particle strikes right wall
        endif

        if( flag .ne. 0 )  then     ! If particle strikes a wall

          strikes(flag) = strikes(flag) + 1

          vxInitial = v(i,1)
          vyInitial = v(i,2)

          !* Reset velocity components as biased Maxwellian,
          !  Exponential dist. in x; Gaussian in y and z


 5        trial = ran2(seed)
 
          if (trial.lt.1.0) then
           v(i,1) = direction(flag)*sqrt(-log(1.0-trial)) * vmpw(flag)
          else
           goto 5
          endif
                     
          v(i,2) = stdev(flag)*randn(seed) + vw(flag)  ! Add wall velocity
          v(i,3) = stdev(flag)*randn(seed)

          ! Time of flight after leaving wall 
          if (abs((x(i)-xold(i))).le.1e-16) then
            write(*,*) 'MOVER: Small diff for dtr! ',x(i)-xold(i)
            stop            
          else
            dtr = tau*(x(i)-xwall(flag))/(x(i)-xold(i))
          endif   

          !* Reset position after leaving wall
          x(i) = xwall(flag) + v(i,1)*dtr

          !* Record velocity change for force measurement
          delv(flag) = delv(flag) + (v(i,2) - vyInitial)
          delu(flag) = delu(flag) + (v(i,1) - vxInitial)

        endif

      enddo

      return
      end
      
