      subroutine pressure

      implicit none
      include 'mc.inc'

      real meanu
      real mcount
      
      meanu = 0.0
      mcount = 0.0

c
c-----Evaluate Pressure using Momentum Flux
c

      do q=1,npart

       if ( (x(q).gt.xplane).and.(xold(q).lt.xplane)     ! Particles moving L-->R
     ^                      .and.vold(q,1).gt.0.0 ) then
          mcount = mcount + vold(q,1)         
       endif

       if ( (x(q).lt.xplane).and.(xold(q).gt.xplane)    ! Particles moving L<--R
     ^                      .and.vold(q,1).lt.0.0 ) then
         mcount = mcount - vold(q,1)
       endif

      enddo     

       press = mcount*neff*mass/(L*L*tau)        ! P=Momentum flux

       do q=1,npart                              ! Reset for next iteration
        xold(q) = x(q)
        vold(q,1) = v(q,1)
        vold(q,2) = v(q,2)
        vold(q,3) = v(q,3)
       enddo

      return
      end


