      function randn(iseed)

      implicit none
      include 'mc.inc'

! Random number generator; Normal (Gaussian) dist.
! Input: seed    Integer seed  (DO NOT USE A SEED OF ZERO)
! Output: randn   Random number, Gaussian distributed

      integer iseed
      real adum, bdum
     
 1    adum = ran2(iseed)
      bdum = ran2(iseed)

      if (adum.lt.1.0) then
       randn = sqrt(-2*log(1.-adum))*cos(6.283185307*bdum)
      else
       goto 1
      endif
                  
      return
      end
