      subroutine sampler
      
      implicit none
      include 'mc.inc'

      integer jjx(NMAX), jjcell  

      !* Compute cell location for each particle
      do i=1,npart
        jjx(i) = int(ncell*x(i)/L) + 1
      enddo

      !* Initialize running sums of number, velocity and v^2
      do i=1,ncell
        sum_n(i)  = 0.0
        sum_vx(i) = 0.0
        sum_vy(i) = 0.0
        sum_vz(i) = 0.0
        sum_v2(i) = 0.0
      enddo

      !* For each particle, accumulate running sums for its cell
      do i=1,npart
        jjcell = jjx(i)  ! Particle i is in cell jcell
        sum_n(jjcell)  = sum_n(jjcell)  + 1
        sum_vx(jjcell) = sum_vx(jjcell) + v(i,1)
        sum_vy(jjcell) = sum_vy(jjcell) + v(i,2)
        sum_vz(jjcell) = sum_vz(jjcell) + v(i,3)
        sum_v2(jjcell) = sum_v2(jjcell) + v(i,1)**2 +
     &                      v(i,2)**2 + v(i,3)**2
      enddo

      !* Use current sums to update sample number, velocity
      !  and temperature
      do i=1,ncell
        if (sum_n(i).le.2) then
         write(*,*) 'Less than 2 particles in cell',i
        endif 
        sum_vx(i) = sum_vx(i)/sum_n(i)
        sum_vy(i) = sum_vy(i)/sum_n(i)
        sum_vz(i) = sum_vz(i)/sum_n(i)
        sum_v2(i) = sum_v2(i)/sum_n(i)
        ave_n(i)  = ave_n(i)  + sum_n(i)
        ave_ux(i) = ave_ux(i) + sum_vx(i)
        ave_uy(i) = ave_uy(i) + sum_vy(i)
        ave_uz(i) = ave_uz(i) + sum_vz(i)
        ave_T(i)  = ave_T(i)  + sum_v2(i) 
      enddo
      nsamp = nsamp + 1
 
      return
      end
