      subroutine sort

      implicit none
      include 'mc.inc'
      
      integer temp(CMAX)
      integer jx(NMAX)

      do i=1,npart                      ! Sort particles into cells
        j = int(x(i)*ncell/L)+1
        jx(i) = min0(j,ncell)
      enddo

      do j=1,ncell                      ! Count particles in cells
        celln(j) = 0                    ! Reset 
      enddo

      do i=1,npart                      
        celln(jx(i)) = celln(jx(i)) + 1
      enddo

      k = 1                             ! Index list as cumulative sum
      do j=1,ncell
        index(j) = k
        k = k + celln(j)
      enddo

      do j=1,ncell                      ! Cross-reference list
        temp(j) = 0
      enddo

      do i=1,npart
        j = jx(i)                       ! Cell address of particle i
        k = index(j) + temp(j)          ! Use cumulative sum to set xref 
        xref(k) = i
        temp(j) = temp(j) + 1
      enddo

      return
      end





