#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>

static char buf[40960];
static char name[32];
static char *prog_name;

extern int errno;

#define NDIR 100


static char dir[32];
struct timeval s;

void 
start()
{
    gettimeofday(&s, NULL);
}


double 
stop()
{
  time_t ds;
  time_t du;
  struct timeval f;
  gettimeofday(&f, NULL);
  ds = f.tv_sec - s.tv_sec;
  du = f.tv_usec - s.tv_usec;
  return (ds) + ((double)du/1000000.0);
}


void 
creat_dir()
{
    int i;

    umask(0);
    for (i = 0; i < NDIR; i++) {
        sprintf(dir, "d%d", i);
        mkdir(dir, 0777);
    }
}

void 
clean_dir()
{
    int i;

    umask(0);
    for (i = 0; i < NDIR; i++) {
        sprintf(dir, "d%d", i);
        rmdir(dir, 0777);
    }
}



void
creat_test(int n, int size)
{
    int i;
    int r;
    int fd;
    int j;
    double elapsed;

    start();
    for (i = 0, j = 0; i < n; i ++) {

      j = i % NDIR;
      sprintf(name, "d%d/g%d", j, i);

      if((fd = open(name, O_RDWR | O_CREAT | O_TRUNC, S_IRWXU)) < 0) {
	printf("%s: create %d(%s) failed %d %d\n", prog_name, i, name,
	       fd, errno);
	exit(1);
      }
      
      if ((r = write(fd, buf, size)) < 0) {
	printf("%s: write failed %d %d\n", prog_name, r, errno);
	exit(1);
      }
      
      if ((r = fsync (fd) < 0)) {
	printf ("%s: fsync failed: %s\n", strerror (errno));
      }

      if ((r = close(fd)) < 0) {
	printf("%s: close failed %d %d\n", r, errno);
      }
      
    }
    elapsed = stop();
    printf("creat: %d files in  %f sec = %f files/sec\n",  n, elapsed,  n/elapsed);
}

#define FLUSH_BLOCK_SIZE 16384
int create_flush_file () 
{
  int fd, r;
  long n;
  char buf[FLUSH_BLOCK_SIZE];

  if((fd = open("FLUSH_TMP", O_RDWR | O_CREAT | O_TRUNC, S_IRWXU)) < 0) {
    printf("%s: failed to create temporary file used to flush the cache. "
	   "Make sure you have 1G free in this file system", 
	   prog_name);
    exit(1);
  }
  
  memset (buf, 0xc5, 8192);  
  for (n = 0; n < 100000; n++) {
    if ((r = write(fd, buf, FLUSH_BLOCK_SIZE)) < 0) {
      printf("%s: failed to create temporary file used to flush the cache. "
	     "Make sure you have 1G free in this file system (%s)", 
	     prog_name,
	     strerror (errno));
      exit(1);
    }
  }

  close (fd);
}


int flush_cache()
{
  int fd, r;
  long n;
  char buf[FLUSH_BLOCK_SIZE];

  if((fd = open("FLUSH_TMP", O_RDONLY, S_IRWXU)) < 0) {
    printf("%s: failed to open the temporary file I use to flush the cache\n",
	   prog_name);
    exit(1);
  }
  
  for (n = 0; n < 100000; n++) {
    if ((r = read(fd, buf, FLUSH_BLOCK_SIZE)) < 0) {
      printf("%s: failed to read temporary file used to flush the cache.\n",
	     prog_name);
      exit(1);
    }
  }
}

int read_test(int n, int size)
{
    int i;
    int r;
    int fd;
    int j;
    double elapsed;

    start();
    for (i = 0, j = 0; i < n; i ++) {
      
      j = i % NDIR;
      sprintf(name, "d%d/g%d", j, i);
      
      if((fd = open(name, O_RDONLY)) < 0) {
	printf("%s: open %d failed %d %d\n", prog_name, i, fd, errno);
	exit(1);
      }
      
      if ((r = read(fd, buf, size)) < 0) {
	printf("%s: read failed %d %d\n", prog_name, r, errno);
	exit(1);
      }
      
      if ((r = close(fd)) < 0) {
	printf("%s: close failed %d %d\n", r, errno);
      }
      
    }
    elapsed = stop();
    
    printf("read: %d files in %f sec = %f files/sec\n",  
	   n, elapsed,  n/elapsed);
}

int delete_test(int n)
{	
    int i;
    int r;
    int fd;
    int j;
    double elapsed;

    start();
    for (i = 0, j = 0; i < n; i ++) {
      
      j = i % NDIR;
      sprintf(name, "d%d/g%d", j, i);
      
      if ((r = unlink(name)) < 0) {
	printf("%s: unlink failed %d\n", prog_name, r);
	exit(1);
      }
      
    }

    elapsed = stop();
    printf("delete: %d files in %f sec = %f files/sec\n",  n, elapsed,  n/elapsed);
}


int main(int argc, char *argv[])
{
    int n;
    int size;

    prog_name = argv[0];

    if (argc != 3) {
	printf("%s: <num files> <file size>\n", prog_name);
	exit(1);
    }

    n = atoi (argv[1]);
    size = atoi (argv[2]);

    printf ("creating a temporary file used to flush the cache: ");
    fflush (stdout);
    creat_dir ();
    create_flush_file ();
    printf ("done.\n");

    printf("small file benchmark: %d %d byte files\n", n, size);

    creat_test (n, size);
    flush_cache ();
    read_test (n, size);
    flush_cache ();
    delete_test (n);

    clean_dir ();
    unlink("t");
}

