@echo off
echo
echo This procedure loads the DS5000 with the BASIC interpreter
echo and the 6121J extensions.  Note that the DS5000 MUST BE IN
echo LOADER MODE for this procedure to function properly.
echo  
echo Due to the way in which the DS5000 automatically determines
echo the baud rate of the serial port, the RS-232 interface between
echo the PC and the DS5000 MUST BE IMPLEMENTED WITH EITHER A DALLAS
echo SEMICONDUCTOR DS1275, DS1228, OR CONVENTIONAL 1488/1489 DEVICES.
echo OTHER SERIAL PORT IMPLEMENTATIONS MAY NOT FUNCTION PROPERLY.
echo  

echo Unlock the DS5000...
echo com 2 > kit.dat
echo speed 9600 >>kit.dat
echo unlock >>kit.dat
echo quit >>kit.dat
kit <kit.dat

echo Fill DS5000 memory with zeros...
echo com 2 > kit.dat
echo speed 9600 >>kit.dat
echo fill 0 >>kit.dat
echo quit >>kit.dat
kit <kit.dat

echo Set DS5000 partition to 3000...
echo com 2 > kit.dat
echo speed 9600 >>kit.dat
echo partition 3000 >>kit.dat
echo quit >>kit.dat
kit <kit.dat

echo Load the BASIC interpreter...
echo com 2 > kit.dat
echo speed 9600 >>kit.dat
echo load basic.hex >>kit.dat
echo quit >>kit.dat
kit <kit.dat

echo Verify the BASIC interpreter...
echo com 2 > kit.dat
echo speed 9600 >>kit.dat
echo verify basic.hex >>kit.dat
echo quit >>kit.dat
kit <kit.dat

echo Load the 6121J extensions...
echo com 2 > kit.dat
echo speed 9600 >>kit.dat
echo load 6121j.hex >>kit.dat
echo quit >>kit.dat
kit <kit.dat

echo Verify the 6121J extensions...
echo com 2 > kit.dat
echo speed 9600 >>kit.dat
echo verify 6121j.hex >>kit.dat
echo quit >>kit.dat
kit <kit.dat

echo DS5000 BASIC/6121J load procedure complete
del  kit.dat