function DV = odeLV(t, V)

% ODELV defines the ODE for velocity V of a Mars lander during last stages of EDL.

% The gravitational constant of Mars is Gm = 3.688 m/s^2.
Gm = 3.688;

% The drag coefficient K = 1.2 and the mass of the lander M = 150 kg.
K = 1.2;
M = 150;

% The differential equation for the lander's velocity V is dV/dt = Gm - K/M * V^2
DV = Gm - K/M * V.^2;

return

% NOTE: The output DV in passed to an ODE solver: see M-file MarsLander.m.
