function timeupdatecallback

% CC Violeta Ivanova, violeta@mit.edu
% TIMEUPDATECALLBACK is a callback function in the Monte Carlo simulations of three
% supermarket checkout systems. This callback updates the arrival and service time
% text fields when the user changes the times with the sliders.
% Developed to support course material in 1.010 Uncertainty in Engineering.
% Faculty: Daniele Veneziano. TA: Andreas Langousis.

fig1 = openfig('simulationsGUI.fig', 'reuse');
figure(fig1)

T_arrival_slider        = findobj( fig1, 'Tag', 'T_arrival_slider');
T_service_slider        = findobj( fig1, 'Tag', 'T_service_slider');
T_arrival_text          = findobj( fig1, 'Tag', 'T_arrival_text');
T_service_text          = findobj( fig1, 'Tag', 'T_service_text');

T_arrival               = get(T_arrival_slider, 'Value');
T_service               = get(T_service_slider, 'Value');

arrival_time            = sprintf('%4.1f', T_arrival);
service_time            = sprintf('%4.1f', T_service);
arrivalstr              = [num2str(arrival_time) ' '];
servicestr              = [num2str(service_time) ' '];  

set( T_arrival_text,      'String', arrivalstr);
set( T_service_text,      'String', servicestr);

return





