% IAP 2007 Introduction to MATLAB: Basic Programming

% EXAMPLE 1 Script and Function M-Files
% A Program that Uses One Script M-File Only

% This is a script m-file.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% A. IMPORT POINTS

% Import X, Y, Z (point coordinates) from file XYZcoords.txt and
% create three vectors X, Y, Z from the first three columns of the file.

data = load('XYZcoords.txt');
X = data(:, 1); 
Y = data(:, 2); 
Z = data(:, 3);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% B. CREATE SURFACE 

% Interpolate a surface z between the control points defined by (X, Y, Z).

[x, y] = meshgrid([-3000:100:3000], [-3000:100:3000]);
z = griddata(X, Y, Z, x, y);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% C. CREATE CUSTOMIZED PLOT

% C1. Create the figure
fig1 = figure('Name','Interpolated Surface');
 
% C2. Create a surface graph of the surface defined by x, y, z
s1 = surf(x, y, z);
colorbar vert

% C3. Get the current axes
axes1 = gca;
 
% C4. Add a plot of the points
hold on
p1 = plot3(X, Y, Z,...
          'Marker', 'o', ...
          'MarkerSize', 4, ...
          'MarkerEdgeColor', [1 1 1],...
          'LineStyle', 'none');
hold off

% C5. Customize the figure and axes colors
set(fig1,  'Color',  [0 0 0]);
set(axes1, 'Color',  [0 0 0], ...
           'XColor', [1 1 1], ...
           'YColor', [1 1 1], ...
           'ZColor', [1 1 1]);

% C6. Create a legend for the points
lp1 = legend(p1,'Input points');
set(lp1, 'Location', 'East', ...
         'TextColor', [1 1 1], ...
         'EdgeColor', [1 1 1]);

% C7. Annotate the figure
title('SURFACE FIT TO DATA POINTS   ', ...
                'Color', [1 1 1], ...
                'FontName', 'Times', ...
                'FontWeight', 'bold', ...
                'FontSize', 16);
xlabel('X',     'Color', 'w', ...
                'FontSize', 12);
ylabel('Y',     'Color', 'w', ...
                'FontSize', 12);
zlabel('Depth', 'Color', 'w', ...
                'FontSize', 12);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% D. SAVE FIGURE

% D1. In MATLAB *.fig format
saveas(fig1, 'surface_points');

% D2. In TIFF format
saveas(fig1, 'surface_points.tif');