function plotdata(xdata, ydata, zdata, X, Y, Z)

% PLOTDATA creates a customized plot from surface and point data.  
% PLOTDATA (XDATA, YDATA, ZDATA, X, Y, Z) creates a surface plot from
% the surface data XDATA, YDATA, ZDATA; adds to it a plot of points created 
% from the vectors X, Y, and Z; annotates the figure; and saves it in
% two files called surface_points.fig and surface_points.tif.
% CC Violeta Ivanova, violeta@mit.edu
     
disp ('Creating figure ...');
    
%% Create figure
fig1 = figure('Name','Interpolated Surface');
 
%% Create a surface graph of the surface
s1 = surf(xdata, ydata, zdata);
colorbar vert

%% Get the current axes
axes1 = gca;
 
%% Create plot of the points
hold on
p1 = plot3(X, Y, Z,...
          'Marker', 'o', ...
          'MarkerSize', 4, ...
          'MarkerEdgeColor', [1 1 1],...
          'LineStyle', 'none');
hold off

%% Customize the figure and axes colors
set(fig1,  'Color',  [0 0 0]);
set(axes1, 'Color',  [0 0 0], ...
           'XColor', [1 1 1], ...
           'YColor', [1 1 1], ...
           'ZColor', [1 1 1]);

%% Create a legend for the points
lp1 = legend(p1,'Input points');
set(lp1, 'Location', 'East', ...
         'TextColor', [1 1 1], ...
         'EdgeColor', [1 1 1]);

%% Annotate figure
title('SURFACE FIT TO DATA POINTS   ', ...
                'Color', [1 1 1], ...
                'FontName', 'Times', ...
                'FontWeight', 'bold', ...
                'FontSize', 16);
xlabel('X',     'Color', 'w', ...
                'FontSize', 12);
ylabel('Y',     'Color', 'w', ...
                'FontSize', 12);
zlabel('Depth', 'Color', 'w', ...
                'FontSize', 12);
            
%% Save the figure in two files
disp('Saving figure ...');
    
saveas(fig1, 'surface_points');
saveas(fig1, 'surface_points.tif');

disp('Figure saved in surface_points.fig and surface_points.tif');
            
            

 
