% IAP 2007 Introduction to MATLAB: Statistics and Data Analysis
% Instructor: Violeta Ivanova, violeta@mit.edu

% EXERCISE 1 MATLAB Statistics Toolbox
% Correlation Coefficient, Hypothesis Testing, ANOVA, Statistical Plots
% Original data for RFID and barcode scanning experiments are in the file
% sampledata.xls, courtesy of Teresa Pontillo, MIT Aeronautics & Astronautics.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% A. DATA IMPORT

% A1. Import RFID experiment data from file RFID.dat to matrix rfid.
% Column 1: No. antennae; Column 2: No. items; Column 3: Type of item;
% Column 4: No. tags; Column 5: Time (sec); Column 6: Accuracy (%)
rfid = load('RFID.dat');

% A2. Import barcode scanning data from file barcode.dat to matrix bc. 
% barcode = load('barcode.dat');
bc = load('barcode.dat');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% B. CORRELATION COEFFICIENT

% B1. Compute correlation coefficients for the RFID independent variables 
% (columns 1-4 in rfid) with the test results (columns 5-6 in rfid)
% Which correlations are significant within 95% confidence interval?

[R, P] = corrcoef(rfid);
[i, j] = find(P<0.05);
[i j]
R
P

% B2. Compute correlations for the time to scan one item with RFID.
time1 = rfid(:, 5) ./ rfid(:, 2);
rfid1 = [rfid(:, 1:4) time1 rfid(:,6)];
[R1, P1] = corrcoef(rfid1);
[i1, j1] = find(P<0.05);
[i1 j1]
R1
P1

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% C. ANALYSIS OF VARIANCE

% C1. Perfom ANOVA to determine if the time per item is correlated to
% the number of items in each scan, and annotate the created box plot. 
anova1(time1, rfid(:,2))
gcf
xlabel('Number of items')
ylabel('Time (sec) per item')
title('RFID Measurements')

% A7. Perfom ANOVA to determine if the accuracy is correlated to the
% number of items in each scan, and if accuracy meets a required 95%.
% Annotate the created plot. 
[p, table, stats] = anova1(rfid(:,6), rfid(:,2))
[c, m] = multcompare(stats)
gcf
ylabel('Number of items')
xlabel('Accuracy %')
title('RFID Measurements')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% D. COMPARISION OF TWO PROCEDURES

% D1. Compute correlations for the time to scan one item with barcode scan.
time1bc = bc(:, 2) ./ bc(:, 1);
bc1 = [bc(:, 1) time1bc];
[r, p] = corrcoef(bc1);
[n, m] = find(P<0.05);
[n m]
r
p

% D2. Perfom ANOVA to determine if the time per item is correlated to
% the number of items in each barcode scan, and annotate the created box plot. 
anova1(time1bc, bc(:,1))
gcf
xlabel('Number of items')
ylabel('Time (sec) per item')
title('Barcode Scanning Measurements')

% D3. Compare graphically the RFID and barcode efficiency (time to scan one item)
% Hint: Use the two box plots (from A6 and A9) and the Property Editor. 



