% IAP 2007 Introduction to MATLAB: Statistics and Data Analysis
% Instructor: Violeta Ivanova, violeta@mit.edu

% EXERCISE 2 Linear Regression & Other Line Fitting
% Linear Regression, Polynomials, PDF Fitting, Residuals, Goodness of Fit

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% A. LOAD DATA

% A1. Load data from file worlddata.dat
% year: calendar year from 1950 to 2000
% N: world population
% Nbil: world population in billions
world = load ('worlddata.dat'); 
year = world(:,1);
N = world (:,2);
Nbil = world(:,3);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% B. POLYNOMIAL FIT

% B1. Fit a quadratic polynomial for Nbil vs. year with POLYFIT
p2 = polyfit(year, Nbil, 2)

% B2. Fit a quadratic and plot the 95% confidence interval with POLYTOOL
P2 = polytool(year, Nbil, 2)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% C. LINEAR REGRESSION

% C1. Perform linear regression of population in billions (Nbil) vs. year
% and compute 95% confidence interval and R^2 statistic with REGRESS. 
X = [ones(length(Nbil), 1) year]
[B, Bint, R, Rint, stats] = regress(Nbil, X)
rcoplot (R, Rint)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% D. CURVE FITTING TOOL

% D1. Use the Curve Fitting Tool to fit different models of Nbil vs. year.
% Compare a quadratic fit to an exponential fit and a Gaussian fit. 
% Compute and compare three predictions for the world population in 2050.
cftool


% D2. Use the Import Wizard to import the data set Star from file star.txt, 
% which includes the magnitudes of a variable star on 600 consecutive nights. 
% Use the Curve Fitting Tool to fit a Fourier curve to the periodic data. 









