function DipArray(action);
%DipArray Superquadrics plotting demonstration.
%   This demo shows plots of various versions of    
%   Barr's "superquadrics" ellipsoid. The shapes  
%   are defined by two parameters, known as         
%   vertical roundness and horizontal roundness.    
%   These two parameters are, in turn, controlled   
%   by the sliders on the side panel of the     
%   Superquadrics window.      
%                                                        
%   By adjusting these parameters, you can make     
%   a cube, a sphere, a cylinder, and dozens of     
%   curious generalized ellipsoids.   

%   Ned Gulley, 6-21-93
%   Copyright 1984-2001 The MathWorks, Inc. 
%   $Revision: 5.9 $  $Date: 2001/04/15 12:03:04 $

if nargin<1,
    action='initialize';
end;

if strcmp(action,'initialize'),
    oldfigNumber=watchon;
%     figNumber=figure( ...
%         'Name','Radiation Pattern of Dipole Array with Changing Phase and Distance', ...
%         'NumberTitle','off', ...
%         'Position',[147, 128, 768, 549],...
%         'Visible','off', ...
%         'Color',0.8*[1 1 1], ...
%         'BackingStore','off');
%     colordef(figNumber,'white')
%     axes( ...
%         'Units','normalized', ...
%         'Position',[0.05 0.05 0.60 0.80], ...
%         'Visible','off');
%    
    figNumber=figure( ...
        'Name','Power Radiation Pattern of n Dipole Array', ...
        'NumberTitle','off', ...
        'Position',[43,57,927,668],...
        'Visible','off', ...
        'Color',0.8*[1 1 1], ...
        'BackingStore','off');
    colordef(figNumber,'white')
    axes( ...
        'Units','normalized', ...
        'Position',[0.00 0.10 0.70 0.80], ...
        'Visible','off');   
    set(gca,'YDir','reverse');
    load('DipoleArray.mat','dipar');
    image(dipar);
    axis off;
   
    %===================================
    % Information for all buttons
    labelColor=[0.8 0.8 0.8];
    top=0.95;
    bottom=0.05;
    btnWid=0.20;
    btnHt=0.05;
    right=0.95;
    left=right-btnWid;
    strWid=0.03;
    % Spacing between the button and the next command's label
    spacing=0.02;
    
    %====================================
    % The CONSOLE frame
    frmBorder=0.05;
    yPos=bottom-frmBorder;
    frmPos=[left-frmBorder yPos btnWid+2*frmBorder 0.9+2*frmBorder];
    h=uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
        'BackgroundColor',[0.50 0.50 0.50]);

    %====================================
    % The first slider
    btnNumber=1;
    yPos=top-(btnNumber-1)*(btnHt+spacing);
    callbackStr='DipArray(''build'');';

    % Generic button information
    sldPos=[left yPos-2*btnHt btnWid btnHt];
    staPos=[left yPos-2.1*btnHt btnWid btnHt/2];
    labelPos1=[left yPos-btnHt btnWid btnHt];
    labelPosleft1=[left-strWid yPos-2*btnHt strWid btnHt];
    labelPosright1=[right yPos-2*btnHt strWid btnHt];
    
    
    sld1Hndl=uicontrol( ...
        'Style','slider', ...
        'Tag','distance', ...
        'Units','normalized', ...
        'Position',sldPos, ...
        'Max',2,...
        'Min',0.25,...
        'Value',0.25,...
        'SliderStep',[1/35 1/7],...
        'Callback',callbackStr);
    
%     get(sld1Hndl,'Value')
    
    sta1Hndl=uicontrol( ...
        'Style','text', ...
        'Tag','displaydis', ...
        'Units','normalized', ...
        'BackgroundColor',[1,1,1],...
        'String',num2str(get(sld1Hndl,'Value')),...
        'Position',staPos);
        
    uicontrol( ...
        'Style','text', ...
        'String','Distance (WaveLength)', ...
        'Units','normalized', ...
        'Position',labelPos1);
    
    uicontrol( ...
        'Style','text', ...
        'String','2', ...
        'Units','normalized', ...
        'BackgroundColor',[0.50 0.50 0.50],...
        'Position',labelPosright1);
    
    uicontrol( ...
        'Style','text', ...
        'String','0.25', ...
        'Units','normalized', ...
        'BackgroundColor',[0.50 0.50 0.50],...
        'Position',labelPosleft1);
    


    %====================================
    % The second slider
    btnNumber=4;
    yPos=top-(btnNumber-1)*(btnHt)-spacing;
    callbackStr='DipArray(''build'');';

    % Generic button information
    sldPos=[left yPos-2*btnHt btnWid btnHt];
    staPos=[left yPos-2.1*btnHt btnWid btnHt/2];
    labelPos1=[left yPos-btnHt btnWid btnHt];
    labelPosleft1=[left-strWid yPos-2*btnHt strWid btnHt];
    labelPosright1=[right yPos-2*btnHt strWid btnHt];
    
    
    sld2Hndl=uicontrol( ...
        'Style','slider', ...
        'Tag','Phasedisplay', ...
        'Units','normalized', ...
        'Position',sldPos, ...
        'Max',360,...
        'Min',0,...
        'Value',0,...
        'SliderStep',[1/72 1/12],...
        'Callback',callbackStr);
    
    sta2Hndl=uicontrol( ...
        'Style','text', ...
        'Tag','displaydis', ...
        'Units','normalized', ...
        'BackgroundColor',[1,1,1],...
        'String',num2str(get(sld2Hndl,'Value')),...
        'Position',staPos);
        
    uicontrol( ...
        'Style','text', ...
        'String','Phase Shift (degree)', ...
        'Units','normalized', ...
        'Position',labelPos1);
    
    uicontrol( ...
        'Style','text', ...
        'String','360', ...
        'Units','normalized', ...
        'BackgroundColor',[0.50 0.50 0.50],...
        'Position',labelPosright1);
    
    uicontrol( ...
        'Style','text', ...
        'String','0', ...
        'Units','normalized', ...
        'BackgroundColor',[0.50 0.50 0.50],...
        'Position',labelPosleft1);
    
   %====================================
   % The Dipole number popup button
   btnNumber=7;
   yPos=top-(btnNumber-1)*(btnHt)-2*spacing;
   labelStr='Dipole number n = 2N + 1';
   popupStr=str2mat('3 ( N = 1)','5 ( N = 2 )','7 ( N = 3 )');
   RsData=[1;2;3];
   callbackStr='DipArray(''build'');';
   
   % Generic button information
   btnPos1=[left yPos-spacing+btnHt/2 btnWid btnHt/2];
   btnPos2=[left yPos-spacing btnWid btnHt/2];
   SourceHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos1, ...
      'String',labelStr);
   popupHndl1=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos2, ...
      'String',popupStr, ...
      'value',1,...
      'UserData',RsData,...
      'Callback',callbackStr);

    %====================================
    % The HELP button
    labelStr='Help';
    callbackStr='DipArray(''info'')';
    uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',[left bottom+btnHt+spacing btnWid btnHt], ...
        'String',labelStr, ...
        'Callback',callbackStr);

    %====================================
    % The CLOSE button
    labelStr='Close';
    callbackStr='close(gcf)';
    uicontrol( ...
        'Style','push', ...
        'Units','normalized', ...
        'Position',[left bottom btnWid btnHt], ...
        'String',labelStr, ...
        'Callback',callbackStr); 
    
    %====================================
    % Make the sliders 16 pixels tall so it looks good on a Mac
    set([sld1Hndl sld2Hndl],'Units','pixel')
    sld1Pos=get(sld1Hndl,'Position');
    sld2Pos=get(sld2Hndl,'Position');
    set(sld1Hndl,'Position',[sld1Pos(1) sld1Pos(2)+sld1Pos(4)-16 sld1Pos(3) 16])
    set(sld2Hndl,'Position',[sld2Pos(1) sld2Pos(2)+sld2Pos(4)-16 sld2Pos(3) 16])
    set([sld1Hndl sld2Hndl],'Units','normalized')

    % Draw the initial superquadric
%     Array(1,1/4,90);
    hndlList=[sld1Hndl, sld2Hndl, sta1Hndl, sta2Hndl, popupHndl1];
    set(figNumber, ...
      'Visible','on', ...
      'UserData',hndlList);
    watchoff(oldfigNumber);
    figure(figNumber);
    drawnow
 
elseif strcmp(action,'build'),
    %====================================
    set(gca,'YDir','normal');
    axHndl=gca;
    figNumber=gcf;
    hndlList=get(figNumber,'Userdata');
    sld1Hndl=hndlList(1);
    sld2Hndl=hndlList(2);
    sta1Hndl=hndlList(3);
    sta2Hndl=hndlList(4);
    popupHndl1=hndlList(5);
 
    % DipArray problem
    Darray=get(sld1Hndl,'Value');
    Parray=get(sld2Hndl,'Value');
    NValue=get(popupHndl1,'Value');
    NMatrix=get(popupHndl1,'UserData');
    Narray=NMatrix(NValue);
    set(sta1Hndl, 'string', num2str(Darray));
    set(sta2Hndl, 'string', num2str(Parray));
    Array(Narray,Darray,Parray);    
    drawnow
 
      
elseif strcmp(action,'info'),
   %====================================
   helpinfo=strvcat(['This software is used to illustate the demonstrations'... 
      ' related to 6.013 Electromagnetics and Applications.'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
   diagHndl=helpdlg(helpinfo,'Information');
   

end;    % if strcmp(action, ...


function succ=Array(Arraytype,Distancetype,Phasetype);

helpinfo=strvcat(['The Demo is not ready'... 
      .'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
if nargin==0,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==1,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==2,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==3,
%     Array = [1,2,3];
%     Distance = [1/4,1/2,1,2];
%     Phase = [0, pi/2, pi, 1.5*pi];
	N = Arraytype;
	a = Distancetype;
    chi = Phasetype*2*pi/360;
    dip = linspace(1,2*N+1,2*N+1);
    phi = linspace(0, 2*pi, 360);
    j = 0;
    for i = 1:360
        denom = sin(1/2*(2*pi*a*cos(phi(i))-chi))^2;
        if denom ~= 0
            j = j+1;
            phir(j) = phi(i);
            rr(j) = sin((N+1/2)*(2*pi*a*cos(phi(i))-chi))^2/denom;
        end
    end
%     r = sin((N+1/2)*(2*pi*a.*cos(phi)-chi)).^2./sin(1/2*(2*pi*a.*cos(phi)-chi)).^2;
%     rmax = max(r);
%     r = r/rmax;
%     polar(phi,r);
    rmax = max(rr);
    rr = rr/rmax;
    polar(phir,rr);

    title([  'Power Radiation pattern of ', num2str(2*N+1),' dipole array, with '...
            ,num2str(chi*360/(2*pi)),' degree phase shift and '...
            ,num2str(a),' \lambda apart in the \theta = \pi/2 plane.'],'fontsize', 8);	
    text(0.9,0,'X');
    text(0,0.9,'Y');
	hold on
	plot((dip-N-1)/(2*N),dip*0,'or');
	hold off
end
