function [ output_args ] = dipoleE( Ftype, display, em, emt )
%DIPOLEE Summary of this function goes here
%  Detailed explanation goes here
%  H0=-I*dl*k^2/(4*pi);
%  Hphi=E0*sin(th).*(sin(omega*t-k*r)./(k*r)-cos(omega*t-k*r)./(k*r).^2);

EMstr=strvcat(['Electric'],['Magnetic']);
helpinfo=strvcat(['The Demo is not ready'... 
      .'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
  
if nargin==0,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==1,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==2,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==3,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==4,
	figNumber=figure( ...
      'Name',['Point ', EMstr(emt,:), ' Dipole Radiation Demo'], ... 
      'NumberTitle','off', ...
      'Visible','on', ...
      'BackingStore','off');
	set(figNumber,'Position',[100,100,810,740]);
	axes( ...
      'Units','normalized', ...
      'Visible','off', ...
      'NextPlot','add');
	set(figNumber,'Menubar','none');
	set(gca,'YDir','reverse');
	axis on;
    set(gca,'XTick', [], 'YTick', []);
	xlabel('Y');
	ylabel('X');
	title([EMstr(em,:),' field of a point dipole']);
	axis([-1,1,-1,1]);
    
    hold off;
	box on;
    
	view(90,90);
    hdensity = 1;    
	H0=-1; % Magnetic field value
    kfield=[2,5,10]; % Field view type
    DisplaySpeed=[13,25]; % Total number of frames for fast and slow display
	k=kfield(Ftype);
	omega=pi;
	m=40; % Number of point on x y axial
	K=horzcat(linspace(-1,-0.05,m),linspace(0.05,1,m));
	[X,Y] = meshgrid(K,K);
	[phi,r] = cart2pol(X,Y);
	ph = pi/2-phi;
	time = linspace(0,1,DisplaySpeed(display));
	[j,n] = size(time);
	M = moviein(n); 
    
	for i=1:n
        cla;
        t=time(i);
        Hphi=H0*(sin(omega*t-k*r)./(k*r)-cos(omega*t-k*r)./(k*r).^2);
        Hx=-sin(phi).*Hphi;
		Hy=+cos(phi).*Hphi;
     	h1 = streamslice(X,Y,Hx,Hy,hdensity,'cubic');
        set(h1,'color','k');
        title([EMstr(em,:),' field of a point dipole at \omegat = ',num2str(360*t),' degree']);

        M(:,i) = getframe(gcf);        
	end
    
end