function Demo4(action)
%   Demo4 shows the radiation of a point electric dipole.
%   This demonstration illustrates the radiation of a point electric dipole       

%   Xiaowei He & Markus Zahn, 2004
%   All Rights Reserved

old_format=get(0,'Format');

if nargin<1,
   action='initialize';
end;

if strcmp(action,'initialize'),
   oldfigNumber=watchon;
   
   figNumber=figure( ...
      'Name','Radiation of a Point Electric Dipole Demo', ...
      'NumberTitle','off', ...
      'Visible','off', ...
      'BackingStore','off');
   set(figNumber,'Position',[50,116,934,591]);
   axes( ...
      'Units','normalized', ...
      'Position',[0.05 0.10 0.65 0.80], ...
      'Visible','off', ...
      'NextPlot','add');
   set(figNumber,'Menubar','none');
   set(gca,'YDir','reverse');
   load('PDipole.mat','pdip');
   image(pdip);
   axis off;
     
   %===================================
   % Information for all buttons
   top=0.95;
   bottom=0.05;
   labelColor=[0.8 0.8 0.8];
   yInitPos=0.90;
   left=0.70;
   btnWid=0.25;
   btnHt=0.08;
   % Spacing between the button and the next command's label
   spacing=0.02;
   
   %====================================
   % The CONSOLE frame
   frmBorder=0.02;
   frmPos=[left-frmBorder bottom-frmBorder btnWid+2*frmBorder 0.9+2*frmBorder];
   h=uicontrol( ...
      'Style','frame', ...
      'Units','normalized', ...
      'Position',frmPos, ...
      'BackgroundColor',[0.5 0.5 0.5]);
   
   %====================================
   % The Electric Field Animation button
   btnNumber=1;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='E Animation';
   cmdStr='ea';
   callbackStr='Demo4(''ea'');';
   
   % Generic button information
   btnPos=[left yPos-spacing btnWid btnHt];
   runHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
   %====================================
   % The Magnetic Field Animation button
   btnNumber=2;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='H Animation';
   cmdStr='ma';
   callbackStr='Demo4(''ma'');';
   
   % Generic button information
   btnPos=[left yPos-spacing btnWid btnHt];
   runHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
   %====================================
   % The Rs popup button
   btnNumber=3;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='Field Range';
   popupStr=str2mat('Near Field','Middle Field','Far Field');
   RsData=[1;2;3];
   
   % Generic button information
   btnPos1=[left yPos-spacing+btnHt/2 btnWid btnHt/2];
   btnPos2=[left yPos-spacing btnWid btnHt/2];
   SourceHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos1, ...
      'String',labelStr);
   popupHndl1=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos2, ...
      'String',popupStr, ...
      'value',3,...
      'UserData',RsData);
  
   %====================================
   % The Rl popup button
   btnNumber=4;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='Display Speed';
   popupStr=str2mat('Fast','Slow');
   RsData=[1;2];
   
   % Generic button information
   btnPos1=[left yPos-spacing+btnHt/2 btnWid btnHt/2];
   btnPos2=[left yPos-spacing btnWid btnHt/2];
   LoadHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos1, ...
      'String',labelStr);
   popupHndl2=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos2, ...
      'String',popupStr, ...
      'Value',1, ...
      'UserData',RsData);
  
  %====================================
   % The Electric and Magnetic Field  button
   btnNumber=5;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='Electric and Magnetic Field Radiation';
   cmdStr='emf';
   callbackStr='Demo4(''emf'');';
   
   % Generic button information
   btnPos=[left yPos-spacing btnWid btnHt];
   runHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
   %====================================
   % The INFO button
   labelStr='Info';
   callbackStr='Demo4(''info'')';
   infoHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom+btnHt+spacing btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   %====================================
   % The CLOSE button
   labelStr='Close';
   callbackStr='close(gcf)';
   closeHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   % Uncover the figure
   hndlList=[popupHndl1,popupHndl2];
   set(figNumber, ...
      'Visible','on', ...
      'UserData',hndlList);
   % Now run the demo. With no arguments, "draft" just draws the Transimission Line.
   watchoff(oldfigNumber);
   figure(figNumber);
   
elseif strcmp(action,'ea'),
   %====================================
   axHndl=gca;
   figNumber=watchon;
   hndlList=get(figNumber,'Userdata');
   popupHndl1=hndlList(1);
   popupHndl2=hndlList(2);
  
   
   % ====== Start of Demo

   Fieldtype=get(popupHndl1,'Value');
   Speedtype=get(popupHndl2,'Value');
   dipoleE(Fieldtype,Speedtype,1,1);
   
   % ====== End of Demo
   watchoff(figNumber);
   
elseif strcmp(action,'ma'),
   %====================================
   axHndl=gca;
   figNumber=watchon;
   hndlList=get(figNumber,'Userdata');
   popupHndl1=hndlList(1);
   popupHndl2=hndlList(2);
  
   
   % ====== Start of Demo

   Fieldtype=get(popupHndl1,'Value');
   Speedtype=get(popupHndl2,'Value');
   dipoleH(Fieldtype,Speedtype,2,1);
   
   % ====== End of Demo
   watchoff(figNumber);
   
elseif strcmp(action,'emf'),
   %====================================
%    axHndl=gca;
   figNumber=watchon;
%    hndlList=get(figNumber,'Userdata');
%    popupHndl1=hndlList(1);
%    popupHndl2=hndlList(2);
%    popupHndl3=hndlList(3);
%   
%    
%    % ====== Start of Demo
% 
%    Fieldtype=get(popupHndl1,'Value');
%    Speedtype=get(popupHndl2,'Value');
%    TimePhase=get(popupHndl3,'Value');
   EMP(1);
   
   % ====== End of Demo
   watchoff(figNumber);
   

 
elseif strcmp(action,'info'),
   helpinfo=strvcat(['This software is used to illustate the demonstrations'... 
      ' related to 6.013 Electromagnetics and Applications.'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
   diagHndl=helpdlg(helpinfo,'Information');
   
end;    % if strcmp(action, ...

%  Restore Format
set(0,'Format',old_format)
