% IAP 2006 Introduction to MATLAB
% Graphics

% EXAMPLE 3 3D Surface and Point Graphs

% A. Import coordinates
% Note: this is the same data we used in Exercise One in Session 1: Interface and Basics

% A1. Import X, Y, Z (point coordinates) from file XYZ_point_coordinates.txt
% Method 1 - Using the Import Wizard
% Open the Import Wizard from File->Import Data... 
% Select file XYZ_point_coordinates.txt.
% The data is imported in the matrix called data.
% Method 2 - By using the load command:
data = load('XYZ_point_coordinates.txt')
% Then put the three columns into three separate vectors X, Y, and X
X = data(:, 1); 
Y = data(:, 2); 
Z = data(:, 3);

% A2. Import x, y, z coordinates of the interpolated cubic spline surface
% from the files we created in Exercise One in Session 1: Interface and Basics
x = load('grid_x.dat');
y = load('grid_y.dat');
z = load('interp_spline_z.dat');

% B. Create 3D graphs from the imported data 
% B1. Plot the surface (x, y, z). This is a cubic spline z over the grid (x,y)
s1=surf(x, y, z)
% This command opens the Figure 1 window and creates the graph in it.
% s1 is a handle to this surface plot, so that we can refer to it later. 
% Figure 1 is the current figure, which MATLAB refers to by a Figure Handle.
% Get the handle to the current figure.
fig1 = gcf
% The handle should be 1, since there is only one figure window open.

% B2. Plot the X, Y, Z points using a red circle symbol.
% First create a new figure window.
figure
% This creates a window Figure 2, which by default is active.
% The next plot will be created in this figure window.
plot3(X, Y, Z, 'ro')
% Get the handle to the current figure. Since Figure 2 is still active,
% the handle should be 2.
fig2 = gcf

% B3. Navigate between figures.
% Method 1
% Click on a figure to make its window active. For example, click on Figure 1. 
% Figure 1 is now set as the current figure. The answer to gcf should be 1.
gcf

% Method 2
% This is useful is you have a lot of windows open and cannot find the figure you want. 
% Calling the figure function brings the desired figure to the top.
figure(fig2)
gcf

% Method 3
% Use the set command with the function handle CurrentFigure.
% This is useful for programming!
set(0, 'CurrentFigure', 1)
gcf
% Set also the handle to the currect axes. Also useful for programming.
axes1=get(gcf, 'CurrentAxes')
% Alternatively:
axes1=gca

% B4. Customize figure properties
% Method 1 - Typing commands in the Command Window
% Get figure properties
get(fig1)
% A pretty long list of attributes appears. Set the figure window name:
set(fig1, 'Name', 'Interpolated Surface')
% Set the figure background color using a preset value e.g. 'w' for White:
set(fig1, 'Color', 'w')  
% Set the figure background color using an RGB vector:
set(fig1, 'Color', [0.95 0.87 0.73])
colorbar vert
shading interp

% Method 2 - Using the Plot Edit mode and the Property Editor
% To turn on the Plot Edit mode of the current figure, 
% click on the "arrow" icon on the figure menu bar or type in the command window:
plotedit on
% This makes Figure 1 (the current figure) editable. Alternatively:
plotedit(fig1)

% Double click on any part of Figure 1, for example on the background.
% This should open the Property Editor for the background. 
% If not, open it from the figure window menubar: View->Property Editor
% Select a new Colormap and a new Figure Color.

% B5. Annotate figure
% Method 1 - typing commands in the Command Window
xlabel('x')
ylabel('y')
zlabel('Depth')
title('Cubic Spline Surface')

% Method 2 - using the Property Editor
% Double click on the title you just created. 
% The Property Editor changes to Property Editor - Text.
% Change the font, e.g. to Helvetica 14. 
% Make other changes to customize the figure as you like it. 
% When you click anywhere on the figure, the Property Editor gets updated.

% B6. Add a second plot on the same figure
% Close Figure 2 first either by closing its window, or by typing:
close(fig2)
% Then add the (X, Y, Z) points to Figure 1 as black dots.
figure(fig1)
hold on
p1 = plot3(X, Y, Z, 'k.')
hold off
legend(p1, 'Input points')

% In Figure 1, select the legend you just created and move it.
% Open View->Plot Edit Toolbar and use it to draw an arrow pointing to 
% the surface s1, then create a text object "Interpolated Surface".

% B7. Save the figure 
% Method 1 - Use File->Save As from the figure window's menu bar
% Save Figure 1 as surface1.fig - this is MATLAB format for figures. 
% surface1.fig can be opened later in the figure editor.
% Save Figure 1 also as surface1.jpg in the JPG format. 

% Method 2 - by typing in the Command Window:
saveas(fig1, 'surface1.tif')
% This saves the figure in the TIFF format.

