% IAP 2006 Introduction to MATLAB
% Graphics

% EXAMPLE 2 2D Curve and Point Subplots

% A. Import coordinates
% This is the same data we used in Exercise Two (Curve Fitting)
% in Session 2: Linear Algebra and Calculus

% A1. Create X, Y coordinate vectors of five points
clear all
X = [2 3 5 6 8]'
Y = [75 86 82 70 40]'
% A2. Import the straight line, quadratic, and cubic fit to the five points
x = load('x_coord.txt');
y1 = load('y_line.txt');
y2 = load('y_quadratic.txt');
y3 = load('y_cubic.txt');

% B. Create a graph with four subplots

% B1. Plot the straight line fit to the five points in the first subplot
s1 = subplot(2, 2, 1)
     p1 = plot(X, Y, 'ro'),  hold on
     P1 = plot(x, y1, 'k-'), hold off
     xlabel('X'); ylabel('Y1')
     axes1 = gca

% B2. Plot the quadratic fit to the five points in the second subplot    
s2 = subplot(2, 2, 2)
     p2 = plot(X, Y, 'ro'),  hold on
     P2 = plot(x, y2, 'b-'), hold off
     xlabel('X'); ylabel('Y2')
     axes2 = gca

% B3. Plot the cubic fit to the five points in the third subplot
s3 = subplot(2, 2, 3)
     p3 = plot(X, Y, 'ro'),  hold on
     P3 = plot(x, y3, 'g-'), hold off
     xlabel('X'); ylabel('Y3')
     axes3 = gca
    
% B4. Make the axes in the three plots the same 
axes(axes1); axis([0 10 0 100]); 
axes(axes2); axis([0 10 0 100]); 
axes(axes3); axis([0 10 0 100]); 

% B5. Add legends and titles to subplots
legend (P1, 'Y1 = aX+b')
legend (P2, 'Y2 = aX^2+bX+c') 
legend (P3, 'Y3 = aX^3+bX^2+cX+d')
title (s1, 'Straight line fit')
title (s2, 'Quadratic fit') 
title (s3, 'Cubic fit') 

% B5. Edit the subplots Using the Property Editor
% Click on the arrow icon to make the entire plot editable.
% Move the legends to the lower left corner of subplots.
% Double click or select View->Property Editor to open the property editor. 
% Change the background color of the entire figure.
% Change the font of the titles to a larger size and bold style.

% Select the straight line in subplot 1. The Property Editor changes to
% Lineseries mode. Change the thickness of the line to 2.0 and the color
% from black to another color e.g. magenta.
% Select the curve in subplot 2 and change the thickness to 2.0.
% Select the curve in subplot 3 and change the thickness to 2.0
% Select the axes in subplot 1 and turn on Grid for X and Y. Do the same
% for the axes in subplots 2 and 3.

% C. Create a fourth subplot with a polynomial fit of 4th order
% C1. Compute the polynomial fit
C4 = polyfit(X, Y, 4);
y4 = polyval(x, C4);

% C3. Create subplot 4
% WRITE YOUR MATLAB COMMANDS HERE


% D. Name Figure 1 and save it
set(1, 'Name', 'Subplots')
% Use the File->Save As menu or type in the command line:
saveas(1, 'subplots.tif')





