function velocitycallback

% CC Violeta Ivanova, MIT Information Services and Technology
% CHANGE_PLANET is a callback function for ROCKETVELOCITY.

fig1 = openfig('rocketGUI.fig', 'reuse');
figure(fig1)

planet_popup            = findobj( fig1, 'Tag', 'planet_popup');
units_popup             = findobj( fig1, 'Tag', 'units_popup');
radius_value_text       = findobj( fig1, 'Tag', 'radius_value_text');
radius_units_text       = findobj( fig1, 'Tag', 'radius_units_text');
gravity_value_text      = findobj( fig1, 'Tag', 'gravity_value_text');
gravity_units_text      = findobj( fig1, 'Tag', 'gravity_units_text');
altitude_input_text     = findobj( fig1, 'Tag', 'altitude_input_text');
altitude_units_text     = findobj( fig1, 'Tag', 'altitude_units_text');
compute_velocity_button = findobj( fig1, 'Tag', 'compute_velocity_button');
velocity_result_text    = findobj( fig1, 'Tag', 'velocity_result_text');
velocity_units_text     = findobj( fig1, 'Tag', 'velocity_units_text');

planet      = get( planet_popup,         'Value' );      % Gives 1 for Earth and 2 for Mars
units       = get( units_popup,          'Value' );      % Gives 1 for Metric and 2 for English
H_text      = get( altitude_input_text,  'String');      % Gets input as a string
H           = str2num(H_text);                           % Converts string to a number H

if units == 1
    unit_type = 'm';    % unit_type is a character i.e. a string made of one character
    set( radius_units_text,      'String', 'km');
    set( altitude_units_text,    'String', 'km');
    set( gravity_units_text,     'String', 'm/sec^2');
    set( velocity_units_text,    'String', 'km/h'); 
    
    if planet == 1      % Earth 
        
            set( radius_value_text,    'String', '6376');      R  = 6376;   % R is a number
            set( gravity_value_text,   'String', '9.814');     g0 = 9.814;  % g0 is a number
            
    elseif planet == 2   % Mars
            set( radius_value_text,    'String', '3396');      R  = 3396;   % R is a number
            set( gravity_value_text,   'String', '3.688');     g0 = 3.688;  % g0 is a number
    end
    
elseif units == 2      
    unit_type = 'e';    % unit_type is a character i.e. a string made of one character
    set( radius_units_text,      'String', 'miles');
    set( altitude_units_text,    'String', 'miles');
    set( gravity_units_text,     'String', 'ft/sec^2');
    set( velocity_units_text,    'String', 'mph'); 
    
    if planet == 1          % Earth
            set( radius_value_text,    'String', '3963');      R  = 3963;   % R is a number
            set( gravity_value_text,   'String', '32.2');      g0 = 32.3;   % g0 is a number
        
    elseif planet == 2      % Mars
            set( radius_value_text,    'String', '2111');      R  = 2111;   % R is a number
            set( gravity_value_text,   'String', '12.1');      g0 = 12.1;   % g0 is a number
    end
end

% Pass gour three numbers and a string to orbital velocity to compute v
V = orbitalvelocity(R, g0, H, unit_type);                % V is a number

% Convert the result to a string to display in the GUI
V = round(V);                                                % Round V to nearest integer.
set( velocity_result_text, 'String', num2str(V));             % num2str(V) converts V to a string

return