% IAP 2006 Introduction to MATLAB
% Programming

% EXAMPLE 3 Orbital Velocity - A Script with Matrix Math Solution
% This example uses the same data as Exercise Two in Session 1: Interface
% and Basics, from NASA's educational site:
% http://exploration.grc.nasa.gov/education/rocket/rktrflght.html

% Compute a rocket's velocity V for a circular orbit around a planet.
% Re is the planet's mean radius.
% g0 is the planet's surface gravitational constant. 
% h is the altitude of the circular orbit.
% V can be computed using the formula developed by Johannes Kepler:
% V = sqrt(g0*Re^2/(Re+h))

% A. Create matrices

% A1. Create a matrix with the values of Re for the Earth, Moon, and Mars.
% The first column is in English units (miles), the second column is in
% metric units (km).
Re = [3963 1079 2111; 6376 1736 3396]'

% A2. Create a matrix with the values of g0 for the Earth, Moon, and Mars.
% The first column is in English units (ft/sec^2).
% The second column is in metric units (m/sec^2).
g0 = [32.2 9.814; 5.3 1.615; 12.1 3.688]

% B. Create coefficients for unit conversion.
% B1. For English units:
uce = 3600^2/5280;
% B2. For metric units:
ucm = 3600^2/1000;

% C. Solve for orbital altitude h = 100 miles = 160 km.

% C1. In English units for the Earth, Moon, and Mars:
g0e = g0(:, 1)
Ree = Re(:, 1)
Ve = sqrt(g0e .* Ree .^2 ./ (Ree+100)*uce)

% C2. In metric units for the Earth, Moon, and Mars:
g0m = g0(:, 2)
Rem = Re(:, 2)
Vm = sqrt(g0m .* Rem .^2 ./ (Rem+160)*ucm)
