% IAP 2006 Introduction to MATLAB
% Programming
% CC Violeta Ivanova, MIT Informaiton Services and Technology

% EXAMPLE 2 Script and Function M-Files
% A Program That Uses A Script M-File and Three Function M-Files

% This is the script m-file. 
% The script uses three functions defined in three function m-files.

% A. Import coordinates

% A1. Import X, Y, Z (point coordinates) from file XYZ_point_coordinates.txt
% Use the function LOADPOINTS defined in m-file loadpoints.m

[X, Y, Z] = loadpoints ('XYZ_point_coordinates.txt');

% A2. Import x, y, z coordinates of the interpolated cubic spline surface
% Use the function LOADMESH defined in m-file loadmesh.m

[x, y, z] = loadmesh ('grid_x.dat', ...
                      'grid_y.dat', ...
                      'interp_spline_z.dat');

% B. Create the customized plot of the surface and points and save the figure
% Use the function PLOTDATA defined in m-file plotdata.m

plotdata (x, y, z, X, Y, Z);

% C. Compute a new surface fit to the points and plot it

[x1, y1, z1] = griddata(X, Y, Z, [-3000:100:3000], [-3000:100:3000]', 'nearest');

plotdata (x1, y1, z1, X, Y, Z);



