% IAP 2006 Introduction to MATLAB
% Programming

% EXAMPLE 2 Script and Function M-Files
% A Program that Uses One Script M-File Only

% This is a script m-file.

% A. Import coordinates

% A1. Import X, Y, Z (point coordinates) from file XYZ_point_coordinates.txt
% And create three vectors X, Y, Z from the first three columns of the file.

data = load('XYZ_point_coordinates.txt');
X = data(:, 1); 
Y = data(:, 2); 
Z = data(:, 3);

% A2. Import x, y, z coordinates of the interpolated cubic spline surface
% from three files and create three matrices from the three files.

x = load ('grid_x.dat', '-ascii');
y = load ('grid_y.dat', '-ascii');
z = load ('interp_spline_z.dat', '-ascii');

% B. Create the customized plot of the surface and points

% B1. Create the figure
fig1 = figure('Name','Interpolated Surface');
 
% B2. Create a surface graph of the surface defined by x, y, z
s1 = surf(x, y, z);
colorbar vert

% B3. Get the current axes
axes1 = gca;
 
% B4. Add a plot of the points
hold on
p1 = plot3(X, Y, Z,...
          'Marker', 'o', ...
          'MarkerSize', 4, ...
          'MarkerEdgeColor', [1 1 1],...
          'LineStyle', 'none');
hold off

% B5. Customize the figure and axes colors
set(fig1,  'Color',  [0 0 0]);
set(axes1, 'Color',  [0 0 0], ...
           'XColor', [1 1 1], ...
           'YColor', [1 1 1], ...
           'ZColor', [1 1 1]);

% B6. Create a legend for the points
lp1 = legend(p1,'Input points');
set(lp1, 'Location', 'East', ...
         'TextColor', [1 1 1], ...
         'EdgeColor', [1 1 1]);

% B7. Annotate the figure
title('SURFACE FIT TO DATA POINTS   ', ...
                'Color', [1 1 1], ...
                'FontName', 'Times', ...
                'FontWeight', 'bold', ...
                'FontSize', 16);
xlabel('X',     'Color', 'w', ...
                'FontSize', 12);
ylabel('Y',     'Color', 'w', ...
                'FontSize', 12);
zlabel('Depth', 'Color', 'w', ...
                'FontSize', 12);
            
% C. Save the figure in two files

% C1. In MATLAB *.fig format
saveas(fig1, 'surface_points');

% C2. In TIFF format
saveas(fig1, 'surface_points.tif');