function [X, Y, Z] = loadpoints(filename) 

% LOADPOINTS loads a matrix from a text file and returns three vectors
% created from the first three columns in the file.
% [X, Y, Z] = LOADPOINTS() opens a browser for file selection first. 
% [X, Y, Z] = LOADPOINTS (FILENAME) loads data from FILENAME and returns 
% three vectors X, Y, Z created from the first three columns in FILENAME.
% If LOADPOINTS is called with more than one argument, it returns an error.
% CC Violeta Ivanova, MIT Information Services & Technology.


% A. Load numbers from a text file

disp('Loading point data ...');

if nargin == 1
    data = load (filename, '-ascii');

else
    [filename, pathname] = uigetfile( ...
       {'*.txt', 'Get Text Files'},  'Pick a file');  
    filename = fullfile(pathname, filename);
    data = load (filename, '-ascii');
end
    
% B. Create three vectors X, Y, Z from the first three columns of the
% loaded file.     

X = data(:, 1); 
Y = data(:, 2); 
Z = data(:, 3);

% C. Check if X, Y, and Z have the same size

if (size(X) == size(Y)) & (size(Y) == size(Z))
    disp('Three vectors were created from an input file.')
    
else
    disp('Warning: the three vectors have different sizes.')
end

return
