% 16.06 / 16.07 MATLAB & Simulink Tutorials
% Fall 2006, Violeta Ivanova, violeta@mit.edu

% EXAMPLE 1-A Mars Lander Velocity
% Show how the lander slows down after the retro rockets are fired

% Solve ODE for a Mars lander velocity after the retro-rockets are fired
% The ODE is: DV/dt = G - K/M *V^2

% A1. Define global variables 
% The lander's mass M = 150 kg and drag coefficient K = 1.2

% CREATE TWO GLOBAL VARIABLES K AND M AND ASSIGN VALUES TO THEM:



% A2. Define conditions at time t=0
% The velocity in free fall V0 = 150 mph = 67.056 m/s
% at 20 m above the Martian surface when the retro-rockets are fired

V0 = 67.056;

% A3. Define the time interval from 0 to 6 seconds at a step 0.05 sec.

% CREATE A VECTOR TSPAN FROM 0 TO 6 AT A STEP OF 0.05:



% A4. Compute numerical solution using the ode45 function
% ode45 is a built-in function for solving nonstiff diferrential equations
% Use also the function odeLanderVelocity, defined in odeLanderVelocity.m.

% APPLY THE SOLVER ODE45 TO COMPUTE THE LANDER'S VELOCITY V VS. TIME T: 



% A6. Compute the accelleration A over time
% The acceleration is the derivative of the velocity V i.e. dV/dt.
% To compute A over time, we pass the vectors t and V to odeLanderVelocity:

A = odeLanderVelocity(t, V);

% A7. Plot V and A vs. time on the same graph
% Can you see how the lander slows down after the retro-rockets are fired?

plot(t, V, 'r-')
hold on
plot(t, A, 'b-')
grid on
hold off
xlabel('Time [sec]')
legend('Velocity [m/s]', 'Acceleration [m/s^2]')
title('Mars Lander EDL: Landing')

 