function DV = odeLanderVelocity(t, V)

% ODELANDERVELOCITY defines the differential equation for the velocity V 
% of a Mars lander, right after the retro-rockets fire and the
% airbag/lander drops the last meters to the Martian surface.
% The gravitational constant of Mars is Gm = 3.688 m/s^2.

% Notes for 16.07 students: this file is a function M-file.
% Function M-files are used to define functions.
% The file name is the same as the function name.
% Function files may call global variables defined elsewhere.
% The first command line in a function M-file starts with "function".

% Use gravitational constant of Mars in metric units: Gm
Gm = 3.688;

% The drag coefficient K and the mass M of the lander are defined elsewhere
global K M

DV = Gm - K/M * V.^2;

return

% The output DV from function ODELANDERVELOCITY in passed to an ODE solver
% in the program MARSLANDER: see M-file MarsLander.m.
