function Y = expmodel(T, A, Alpha, Omega, Phi);
% EXPMODEL computes step response y(t) = a*(1-exp(alpha*t)*cos(omega*t+phi)).
% EXPMODEL(T, A, Alpha, Omega, Phi) takes as input arguments a vector T and 
% four scalar values A, Alpha, Omega, and Phi, and returns an output argument,  
% the vector Y, which is the step response as a function of time.    

Y = A * (1 - exp(Alpha .* T) .* cos(Omega .* T + Phi));
