% IAP 2007 Introduction to MATLAB: Graphics & Visualization
% Instructor: Violeta Ivanova, violeta@mit.edu

% Example 2: 3D Surface and Point Graphs
% MATLAB 3D plotting, surface and axis handles, graphics customizations. 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% A. IMPORT POINT COORDINATES

% A1. Import of X, Y, Z (irregular mesh points) from file XYZpoints.txt
% Open the Import Wizard from File->Import Data... and select file XYZpoints.txt.
% Toggle on "Create Vectors From Each Column Using Column Names" and import X, Y, Z.



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% B. INTERPOLATE SURFACE FROM POINTS

% B1. Create a regular grid (-3000<=x<=3000, -3000<=y<=3000) using function
% MESHGRID. Use spacing of 100 along both x and y. 
% Note: The grid covers the same X, Y area as the points imported in part A.



% B2. Interpolate a surface z over the (x,y) grid, between the control points
% defined by (X, Y, Z), using function GRIDDATA.
% Note: GRIDDATA uses cubic spline as default interpolation.



% B3. Compute surface z1, using the "nearest neighbor" method for interpolation:



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% C. CREATE 3D GRAPHS

% C1. Plot the surface z over the grid (x,y) using function SURF.


% C2. Get the handle to the current figure. Hint: Use function GCF.


% C3. Create a new figure window. Hint: use function FIGURE.


% C4. Plot the X, Y, Z points using a red circle symbol.


% C5. Get the handle to the current figure (which is Figure 2). 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% D. USE FIGURE AND AXIS HANDLES

% D1. Navigate between figures, e.g. bring Figure 1 to the top of your screen. 



% D2. Bring Figure 2 to the top using function SET with function handle CurrentFigure.
% NOTE: This is useful for programming!



% D3. Set also the handle to the currect axes. Hint: Use function GCA.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% E. CUSTOMIZE FIGURE PROPERTIES
% NOTE: Do not use the Property Editor!

% E1. List all figure properties for Figure 1. Hint: Use function GET.


% E2. Set the figure window name to "Interpolated Surface".


% E3. Set the figure background color using a preset value 'w' for White:


% E4. Set the figure background color using an RGB vector:


% E5. Close Figure 2



% E6. Add the (X, Y, Z) points to Figure 1 as black dots. 







%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% F. PROPERTY EDITOR

% F1. Annotate and customize Figure 1 using the Property Editor in Plot Edit mode.

% F2. Save the figure in a JPEG format from the Property Editor.

% F3. Save the figure in TIFF format ***without*** the Property Editor. 
% Hint: use function SAVEAS.


