% IAP 2007 Introduction to MATLAB: Calculus, Linear Algebra, Differential Equations
% Instructor: Violeta Ivanova, violeta@mit.edu

% ODE EXAMPLE: Mars Lander Velocity
% Show how the lander slows down during last stage of EDL (entry, descent, landing). 
% Hint: solve the ODE for the lander's velocity V: dV/dt = Gm - K/M *V^2

% A1. Define conditions at time t=0: velocity in free fall V0 = 150 mph = 67.056 m/s 

V0 = 67.056;

% A2. Define the time interval TSPAN from 0 to 6 seconds at a step 0.05.

tspan = [0 : 0.05 : 6];

% A3. Compute a numerical solution using the ODE solver ODE45.

[t, V] = ode45( @odeLV, tspan, V0 );

% A4. Compute the accelleration A over time (A = dV/dt).

A = odeLV(t, V);

% A5. Plot V and A vs. time to show how the lander slows down.

plot(t, V, 'r-')
hold on
plot(t, A, 'b-')
grid on
hold off
xlabel('Time [sec]')
legend('Velocity [m/s]', 'Acceleration [m/s^2]')
title('Mars Lander EDL: Landing')

 