function systems123

% CC Violeta Ivanova, violeta@mit.edu
% SYSTEMS123 opens a GUI for computing Monte Carlo simulations of three
% supermarket checkout systems.
% Developed to support course material in 1.010 Uncertainty in Engineering.
% Faculty: Daniele Veneziano. TA: Andreas Langousis.

fig1 = openfig('simulationsGUI.fig', 'reuse');
figure(fig1)

set(fig1, 'DoubleBuffer',       'on')
set(fig1, 'HandleVisibility',   'on')

N_counters_popup        = findobj( fig1, 'Tag', 'N_counters_popup');
N_states_popup          = findobj( fig1, 'Tag', 'N_states_popup');
T_arrival_slider        = findobj( fig1, 'Tag', 'T_arrival_slider');
T_service_slider        = findobj( fig1, 'Tag', 'T_service_slider');
T_arrival_text          = findobj( fig1, 'Tag', 'T_arrival_text');
T_service_text          = findobj( fig1, 'Tag', 'T_service_text');
accuracy_popup          = findobj( fig1, 'Tag', 'accuracy_popup');
run_button              = findobj( fig1, 'Tag', 'run_button');

set( N_counters_popup,      'String', {'1', '2', '3', '4', '5', '6', ...
                                       '7', '8', '9', '10'});
set( N_states_popup,        'String', {'1500', '5000', '10000', '15000', '20000','25000','30000',...
                                       '40000','50000'});
set( accuracy_popup,        'String', {'0.01', '0.005', '0.001','0.0005','0.0001'});
set( N_counters_popup,      'Value' ,  5);
set( N_states_popup,        'Value' ,  3);
set( accuracy_popup,        'Value' ,  1);
set( T_arrival_slider,      'Min',     1);
set( T_arrival_slider,      'Max',     15);
set( T_arrival_slider,      'Value',   5);
set( T_service_slider,      'Min',     5);
set( T_service_slider,      'Max',     20);
set( T_service_slider,      'Value',   10);
set( T_arrival_text,        'String', ' 5.0 ');
set( T_service_text,        'String', '10.0 ');

set(run_button,             'Callback', 'runsimulationcallback');
set(T_arrival_slider,       'Callback', 'timeupdatecallback');
set(T_service_slider,       'Callback', 'timeupdatecallback');

return





