% IAP 2007 Introduction to MATLAB: Calculus, Linear Algebra, Differential Equations
% Instructor: Violeta Ivanova, violeta@mit.edu

% Example 2: Linear Systems, Convolution: RC Circuit
% This exercise is based on Prof. Stephen Hall's Signals and Systems lectures 
% for 16.01-16.04 Unified Engineering.

% NOTE: consult this session's handout for illustrations (slides 27-29).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% A. ANALYTICAL SOLUTION

% A1. Define a time interval 0<t<4 at a step dt = 0.01s:
dt = 0.01;
t = [0 : dt : 4];

% A2. Compute the number of elements, nt, of the time vector t:
nt = length(t);

% A3. Compute the impulse response gt as g(t) = e^(-1.5t)
gt = exp(-1.5*t);

% A4. Compute the input ut as u(t) = e^-t 
ut = exp(-t);

% A5. Compute the response yt using an analytical solution y(t) = 2e^(-t)-2e^(-1.5t)
yt = 2*exp(-t) - 2*exp(-1.5*t);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% B. SOLUTION USING CONVOLUTION

% B1. Compute the response y using the built-in MATLAB function CONV
% Note: the response must be scaled for the time interval t and step dt

y = conv(gt, ut) * dt;
y = y(1 : nt);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% C. PLOTTING

% C1. Plot the input ut and impulse response gt vs. time t on the same plot:

plot(t, ut, 'k-');
hold on
plot(t, gt, 'g-');
title('Response of a Linear Time-Invariant System')

% C2. Plot on the same plot and compare the response computed analytically, yt, 
% and the response computed numerically with function CONV, y:

plot(t, yt)
plot(t, y, 'r--')
hold off
xlabel('Time (s)')
legend('Input u(t)', 'Impulse response g(t)', 'Response y(t)', 'Response y=conv(g,u)')

                              