% IAP 2007 Introduction to MATLAB: Interface and Basics
% Instructor: Violeta Ivanova, violeta@mit.edu

% EXAMPLE 1 Massachusetts Census Data
% Data import & export, variables, vectors, operators, built-in functions.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% A. DATA I/O

% A1. Import census data using the Import Wizard
% Load the numerical data from file MA2000census.dat into a matrix called N.
% Hint: import only the numerical 14x9 matrix data after changing its name.

% A2. Display the elements of the matrix N
N

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% B. VECTORS & MATRICES

% B1. Create a vector Area of county areas from matrix N:
Area = N(:, 1)

% B2. Create vectors M and F with county populations by gender:
M = N(:, 2)
F = N(:, 3)

% B3. Create a vector P with total county populations:
P = N(:, 4)

% B4. Create a matrix G with county populations of both genders: males in one
% column, and females in the second collumn.

% From the matrix N:
G1 = N(:, 2:3)

% From the two vectors M and F:
G2 = [M F]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% C. MATRIX OPERATIONS

% C1. Addition: From the vectors M and F, create a vector All with total number
% of people in each county.

All = M + F

% C2. Division: Create a column vector Ppa with population density (number of people 
% per area) for each county. Note: you must use the . operator!

Ppa = P ./ Area

% C3. Create a 14x2 matrix Pct with percents of males (one column) and females 
% (another column) for each county. Note: you must use the . operator! 

Pct = [M ./ P   F ./ P] * 100

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% D. VARIABLES

% Test what variables have been created so far with WHO or WHOS:
whos

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% E. BUILT-IN FUNCTIONS

% E1. Function SUM: Compute the total number MAall of residents in MA. 
MAall = sum(P)

% E2. Function MEAN and STD: Compute the mean and standard deviation 
% of the numbers of males and the numbers of females in MA counties.

meanG = mean(G1)
stdG = std(G1)

% E3. Function SAVE: Export the percentile matrix Pct to a text file.
save 'MA2000percents.txt' Pct -ascii

% E4. Function LOAD: Import the saved data from the file into a matrix Percents.

Percents = load('MA2000percents.txt')


