% IAP 2007 Introduction to MATLAB: Graphics
% Instructor: Violeta Ivanova, violeta@mit.edu

% Example 1: Subplots
% MATLAB 2D plotting, multiple datasets in graphs, figures with subplots.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% A. COMPUTE FOUR CURVES 

% A1. Compute an impulse response GT as g(t) = e^(-1.5t) over time
% interval 0<=t<=4 at a step dt = 0.01:

dt = 0.01;
t = [0 : dt : 4];
GT = exp(-1.5*t);

% A2. Compute an input UT as u(t) = e^-t over the same time interval t:
UT = exp(-t);

% A3. Compute the response YT as y(t) = 2e^(-t)-2e^(-1.5t) over the same t:
YT = 2*exp(-t) - 2*exp(-1.5*t);

% A4. Compute the approximate response YC using function CONV over the same t:

nt = length(t);
YC = conv(GT, UT) * dt;
YC = YC(1 : nt);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% B. PLOTTING

% B1. Create a figure with two subplots one above each other. 
% Plot the input UT and the impulse response GT vs. time t on the top subplot
% (use different colors and/or markers). Add figure title and subplot legend.

subplot(211)
plot(t, UT, 'k-');
hold on
plot(t, GT, 'g-');
hold off
legend('Input u(t)', 'Impulse response g(t)')
title('Response of a Linear Time-Invariant System')

% B2. Plot the analytical response, YT, and the response computed with convolution, 
% YC, on the bottom subplot. Add an x-label and a legend to the subplot.

subplot(212)
plot(t, YT)
hold on
plot(t, YC, 'r--')
hold off
xlabel('Time (s)')
legend('Response y(t)', 'Response y=conv(g,u)')

                              