% IAP 2007 Introduction to MATLAB: Basic Programming
% Instructor: Violeta Ivanova, violeta@mit.edu

% EXERCISE 2 Orbital Velocity Computation Program
% An interactive program that uses this script M-file and the function
% ORBITALVELOCITY defined in the function M-file orbitalvelocity.m.

% MATLAB program flow control statements, relational and logical operators,
% editor / debugger, data types, numeric and string operations.

% Add the Moon as an option for user selection in the Command Window.
% In metric units:  Moon radius Re = 1736; gravity g0 = 1.615;
% In English units: Moon radius Re = 1079; gravity g0 = 5.3;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% A. COMMAND WINDOW INPUT

disp('This program computes circular orbital velocity.')

% A1. INPUT OF UNITS FOR COMPUTATION

units = input('What units? E for English or M for metric: ', 's');

if isempty(units)
    units = 'm';
    disp('The program will use default metric units.')

else 
    units = lower(units);
    
    switch units
        case {'m', 'metric'}
            units = 'm';
            disp('The program will use metric units.')
        case {'e', 'english'}
            units = 'e';
            disp('The program will use English units.')
        otherwise 
            error('Unsupported units.')
    end
end

% A2. INPUT ABOUT THE PLANET

disp ('1. Earth')
disp ('2. Mars')
disp ('3. Moon')

planet = input('Which planet: ', 's');

if isempty(planet)
    planet = 'Earth';
    disp('Assuming planet Earth ...')

else 
    planet = lower(planet);
    
    switch planet
        
        case {'1', 'earth'}
            planet = 'Earth';
            if strcmp(units, 'm')
                Re = 6376; g0 = 9.814;
                disp('Computing for planet Earth in metric units ...')
            else
                Re = 3963; g0 = 32.2;
                disp('Computing for planet Earth in English units ...')
            end

        case {'2', 'mars'}
            planet = 'Mars';
            if strcmp(units, 'm')
                Re = 3396; g0 = 3.688;
                disp('Computing for planet Mars in metric units ...')
            else
                Re = 2111; g0 = 12.1;
                disp('Computing for planet Mars in English units ...')
            end
            
       case {'3', 'moon'}
            planet = 'Moon';
            if strcmp(units, 'm')
                Re = 1736; g0 = 1.615;
                disp('Computing for planet Moon in metric units ...')
            else
                Re = 1079; g0 = 5.3;
                disp('Computing for planet Moon in English units ...')
            end
            
        otherwise 
            Re  = input('Enter mean radius of the planet: ');
            g0 = input('Enter gravitational constant of the planet: ');
            if (Re <= 0 || g0 <= 0)
                error('Impossible values for Re or g0.')
            end
    end
end

% A3. INPUT OF THE ALTITUDE

altitude = input('What altitude above the planet: ');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% B. ORBITAL VELOCITY COMPUTATION

V = orbitalvelocity(Re, g0, altitude, units);


