function Demo3(action)
%   Demo3 shows the radiation of a point electric dipole.
%   This demonstration illustrates the radiation of a point electric dipole       

%   Xiaowei He & Markus Zahn, 2004
%   All Rights Reserved

old_format=get(0,'Format');

if nargin<1,
   action='initialize';
end;

if strcmp(action,'initialize'),
   oldfigNumber=watchon;
   
   figNumber=figure( ...
      'Name','Power Radiation of Dipole Arrays Demo', ...
      'NumberTitle','off', ...
      'Visible','off', ...
      'BackingStore','off');
   set(figNumber,'Position',[43,57,927,668]);
   axes( ...
      'Units','normalized', ...
      'Position',[0.05 0.0 0.70 0.90], ...
      'Visible','off', ...
      'NextPlot','add');
   set(figNumber,'Menubar','none');
   set(gca,'YDir','reverse');
   load('DipoleArray.mat','dipar');
   image(dipar);
   axis off;
     
   %===================================
   % Information for all buttons
   top=0.95;
   bottom=0.05;
   labelColor=[0.8 0.8 0.8];
   yInitPos=0.90;
   left=0.70;
   btnWid=0.25;
   btnHt=0.08;
   % Spacing between the button and the next command's label
   spacing=0.02;
   
   %====================================
   % The CONSOLE frame
   frmBorder=0.02;
   frmPos=[left-frmBorder bottom-frmBorder btnWid+2*frmBorder 0.9+2*frmBorder];
   h=uicontrol( ...
      'Style','frame', ...
      'Units','normalized', ...
      'Position',frmPos, ...
      'BackgroundColor',[0.5 0.5 0.5]);
   
   %====================================
   % The Two Dipole button
   labelStr='Two Dipole Array';
   callbackStr='Demo3(''twodipole'')';
   infoHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom+8*(btnHt+spacing) btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
   %====================================
   % The Condemo button
   labelStr='n Dipole Array (n = 3, 5, 7)';
   callbackStr='Demo3(''condemo'')';
   infoHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom+7*(btnHt+spacing) btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
   %====================================
   % The INFO button
   labelStr='Info';
   callbackStr='Demo3(''info'')';
   infoHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom+btnHt+spacing btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   %====================================
   % The CLOSE button
   labelStr='Close';
   callbackStr='close(gcf)';
   closeHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   % Uncover the figure
   set(figNumber, ...
      'Visible','on');
   % Now run the demo. With no arguments, "draft" just draws the Transimission Line.
   watchoff(oldfigNumber);
   figure(figNumber);
   

elseif strcmp(action,'twodipole'),
    
   TwoDipArray;
   
elseif strcmp(action,'condemo'),
    
   DipArray;
   
elseif strcmp(action,'info'),
   helpinfo=strvcat(['This software is used to illustate the demonstrations'... 
      ' related to 6.013 Electromagnetics and Applications.'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
   diagHndl=helpdlg(helpinfo,'Information');
   
end;    % if strcmp(action, ...

%  Restore Format
set(0,'Format',old_format)