function Demos(action)
%   Demos is part of the 6.013 course material.
%   This program illustrates some of the very interesting demonstrations
%   All the equation and formula related in the program are from Zahn's book

%   Xiaowei He & Markus Zahn, 2004
%   All Rights Reserved

%   Initialize the main Frame
if nargin<1,
    action='initialize';
end;

if strcmp(action,'initialize'),
   oldFigNumber=watchon;
   figNumber=figure( ...
      'Name','MIT 6.013 Demos Window', ...
      'NumberTitle','off', ...
      'Visible','off', ...
      'BackingStore','off');
   set(figNumber,'Position',[107,167,857,544]);
   axes( ...
      'Units','normalized', ...
      'Position',[0.05 0.2 0.65 0.70], ...
      'Visible','off', ...
      'NextPlot','add');
   set(gca,'YDir','reverse');
   set(figNumber,'Menubar','none');
   
   %================================
   % Information for all buttons
   top=0.95;
   bottom=0.05;
   labelColor=[0.8 0.8 0.8];
   yInitPos=0.90;
   left=0.70;
   btnWid=0.25;
   btnHt=0.10;
   % Spacing between the button and the next command's label
   spacing=0.02;
   load('MITDemo.mat','banner','bannerMap');
   bannerH=image(banner,'Tag','banner');
   axis off;
   watchoff(oldFigNumber);
   figure(figNumber);
   

   %================================
   % The CONSOLE frame
   frmBorder=0.02;
   frmPos=[left-frmBorder bottom-frmBorder btnWid+2*frmBorder 0.9+2*frmBorder];
   h=uicontrol( ...
      'Style','frame', ...
      'Units','normalized', ...
      'Position',frmPos, ...
      'BackgroundColor',[0.5 0.5 0.5]);
   
   %================================
   % The Demo1 button
   btnNumber=1;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='TransmissionLine';
   cmdStr='Demo1';
   callbackStr='Demos(''Demo1'');';
   
   % Generic button information
   btnPos=[left yPos-spacing btnWid btnHt];
   Demo1Hndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
   %================================
   % The Demo2 button 
   labelStr='Rectangular Waveguide';
   callbackStr='Demos(''Demo2'')';
   Demo2Hndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left yPos-spacing-1*(btnHt+spacing) btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
   %================================
   % The Demo3 button 
   labelStr='Radiation Pattern of Dipole Array';
   callbackStr='Demos(''Demo3'')';
   Demo3Hndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left yPos-spacing-2*(btnHt+spacing) btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
   %================================
   % The Demo4 button 
   labelStr='A Point Electric Dipole Radiation';
   callbackStr='Demos(''Demo4'')';
   Demo4Hndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left yPos-spacing-3*(btnHt+spacing) btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   %================================
   % The Demo5 button 
   labelStr='A Point Magnetic Dipole Radiation';
   callbackStr='Demos(''Demo5'')';
   Demos5Hndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left yPos-spacing-4*(btnHt+spacing) btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
   %================================
   % The INFO button
   labelStr='Info';
   callbackStr='Demos(''info'')';
   infoHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom+btnHt+spacing btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   %================================
   % The CLOSE button
   labelStr='Close';
   callbackStr='clear all; close(gcf)';
   closeHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   % Recover the figure property
   watchoff(oldFigNumber);
   figure(figNumber);
   
elseif strcmp(action,'Demo1'),
   %================================
   Demo1;
   % ====== End of Demo1   
   
elseif strcmp(action,'Demo2'),
   %================================
   Demo2;
   % ====== End of Demo2   
   
elseif strcmp(action,'Demo3'),
   %====================================
   Demo3;
   %======= End of Demo3
   
elseif strcmp(action,'Demo4'),
   %====================================
   Demo4;
   %======= End of Demo4
   
elseif strcmp(action,'Demo5'),
   %====================================
   Demo5;
   %======= End of Demo5
  
elseif strcmp(action,'info'),
   %====================================
   helpinfo=strvcat(['This software is used to illustate the demonstrations'... 
      ' related to 6.013 Electromagnetics and Applications.'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
   diagHndl=helpdlg(helpinfo,'Information');
   
end;    
   %====================================