function EMP(em, action)
%   Draft draw the Electric and Magnetic field radiation of a electric dipole.

%   Xiaowei He & Markus Zahn, 2004
%   All Rights Reserved

%   Define the constant
old_format=get(0,'Format');
EMstr=strvcat(['Electric'],['Magnetic']);

if nargin<2,
   action='initialize';
end;

if strcmp(action,'initialize'),
   oldfigNumber=watchon;
   
   figNumber=figure( ...
      'Name',['Radiation of a Point ', EMstr(em,:), ' Dipole Demo'], ...
      'NumberTitle','off', ...
      'Visible','off', ...
      'BackingStore','off');
   set(figNumber,'Position',[40,280,1200,500]);
   axes( ...
      'Units','normalized', ...
      'Position',[0.00 0.10 0.80 0.80], ...
      'Visible','off', ...
      'NextPlot','add');
%    set(figNumber,'Menubar','none');
        
   %===================================
   % Information for all buttons
   top=0.90;
   bottom=0.05;
   labelColor=[0.8 0.8 0.8];
   yInitPos=0.90;
   left=0.85;
   btnWid=0.11;
   btnHt=0.08;
   % Spacing between the button and the next command's label
   spacing=0.02;
   
   %====================================
   % The CONSOLE frame
   frmBorder=0.02;
   frmPos=[left-frmBorder bottom-frmBorder btnWid+2*frmBorder 0.9+2*frmBorder];
   h=uicontrol( ...
      'Style','frame', ...
      'Units','normalized', ...
      'Position',frmPos, ...
      'BackgroundColor',[0.5 0.5 0.5]);
   
   %====================================
   % The Time popup button
   btnNumber=1;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='Omega*t (degree)';
   popupStr=str2mat('0','30','45','60','90','180');
   RsData=[0,30,45,60,90,180]/360;
   callbackStr='EMP(1, ''run'');';
   
   % Generic button information
   btnPos1=[left yPos-spacing+btnHt/2 btnWid btnHt/2];
   btnPos2=[left yPos-spacing btnWid btnHt/2];
   TimeHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos1, ...
      'String',labelStr);
   popupHndl1=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos2, ...
      'String',popupStr, ...
      'Value',1, ...
      'UserData',RsData,...
      'Callback',callbackStr);

  
   %====================================
   % The INFO button
   labelStr='Info';
   callbackStr='Demo4(''info'')';
   infoHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom+btnHt+spacing btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   %====================================
   % The CLOSE button
   labelStr='Close';
   callbackStr='close(gcf)';
   closeHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   % Uncover the figure
   hndlList=[popupHndl1, em];
   set(figNumber, ...
      'Visible','on', ...
      'UserData',hndlList);
   EMPlot(1, em);
   % Now run the demo. With no arguments, "draft" just draws the Transimission Line.
   watchoff(oldfigNumber);
   figure(figNumber);
   
   
elseif strcmp(action,'run'),
   %====================================
   axHndl=gca;
   figNumber=watchon;
   hndlList=get(figNumber,'Userdata');
   popupHndl1=hndlList(1);
   em=hndlList(2);
   TimePhase=get(popupHndl1,'Value');
   EMPlot(TimePhase, em);
   
   % ====== End of Demo
   watchoff(figNumber);
   

 
elseif strcmp(action,'info'),
   helpinfo=strvcat(['This software is used to illustate the demonstrations'... 
      ' related to 6.013 Electromagnetics and Applications.'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
   diagHndl=helpdlg(helpinfo,'Information');
   
end;    % if strcmp(action, ...

%  Restore Format
set(0,'Format',old_format)





function EMPlot(ttype, em)
%   Draft draw the Electric and Magnetic field radiation of a electric dipole.

%   Xiaowei He & Markus Zahn, 2004
%   All Rights Reserved

%   Define the constant
edensity = 3;
mdensity = 1;
times = [0,30,45,60,90,180]/360;
EMstr=strvcat(['electric'],['magnetic']);
Ftype = 3;
helpinfo=strvcat(['The Demo is not ready'... 
      .'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
  
if nargin==0,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==1,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==2,
    t = times(ttype);
	      
	E0=-1; % Electric field value
    H0=-1; % Magnetic field value
    kfield=[2,5,10]; % Field view type
    k=kfield(Ftype);
	omega=2*pi;
	m=40; % Number of point on x y axial
	K=horzcat(linspace(-1,-0.05,m),linspace(0.05,1,m));
	[X,Y] = meshgrid(K,K);
	[theta,r] = cart2pol(X,Y);
	th = pi/2-theta;
    % Calculate the Electric field
	Er=-E0*2*cos(th).*(cos(omega*t-k*r)./(k*r).^2+sin(omega*t-k*r)./(k*r).^3);
	Eth=E0*sin(th).*(sin(omega*t-k*r)./(k*r)-cos(omega*t-k*r)./(k*r).^2-sin(omega*t-k*r)./(k*r).^3);
	Ex=cos(th).*Er-sin(th).*Eth;
	Ey=sin(th).*Er+cos(th).*Eth;
    % Calculate the Magnetic field
    Hphi=H0*(sin(omega*t-k*r)./(k*r)-cos(omega*t-k*r)./(k*r).^2);
    Hx=-sin(theta).*Hphi;
	Hy=+cos(theta).*Hphi;
    AxHndl1=axes( ...
      'Units','normalized', ...
      'Position',[0.05 0.10 0.35 0.80], ...
      'Visible','on', ...
      'NextPlot','add');
    box on;
	title(['Electric field of a point ', EMstr(em,:), ' dipole.']);
	axis([-1,1,-1,1]); 
    set(gca,'XTick', [], 'YTick', []);
	if em==1
        xlabel('Y');
	    ylabel('Z');
		h1 = streamslice(X,Y,Ey,Ex,edensity,'cubic');
    else
        set(gca,'YDir','reverse');
        xlabel('X');
	    ylabel('Y');
        h1 = streamslice(X,Y,Hx,Hy,1,'cubic');
    end
    set(h1,'color','k');
    AxHndl2=axes( ...
      'Units','normalized', ...
      'Position',[0.45 0.10 0.35 0.80], ...
      'Visible','on', ...
      'NextPlot','add');
    box on;
   	title(['Magnetic field of a point ', EMstr(em,:), ' dipole.']);
    axis([-1,1,-1,1]);
    set(gca,'XTick', [], 'YTick', []);
    if em==1
        xlabel('X');
	    ylabel('Y');
        h2 = streamslice(X,Y,Hx,Hy,1,'cubic');
    else
        xlabel('Y');
	    ylabel('Z');
        h2 = streamslice(X,Y,Ey,Ex,edensity,'cubic');
    end
    set(h2,'color','k');   
end