function Demo2(action)
%   Demo2 show the electric field and magnetic field on the 
%   rectangular metal wave guide.
%   This demonstration also illustrates the charge density
%   distribution on the wall of the metal waveguide.
                                                
%   Use the popup menus to select the TE and TM Mode of EM wave      
%   Then by pushing the "Run" button, you can see the electric                              
%   field and magnatic field distribution on xy plane of the waveguide                                              
%   Use the "m = " and "n = " radio buttons to choose which type of mode you   
%   want to view. Use the formula bottons to show the formula for 
%   the fields and field lines.

%   Xiaowei He & Markus Zahn, 2004
%   All Rights Reserved

old_format=get(0,'Format');

if nargin<1,
   action='initialize';
end;

if strcmp(action,'initialize'),
   oldfigNumber=watchon;
   
   figNumber=figure( ...
      'Name','Rectangular Metal Waveguide Demo', ...
      'NumberTitle','off', ...
      'Visible','off', ...
      'BackingStore','off');
   set(figNumber,'Position',[40,93,955,625]);
   axes( ...
      'Units','normalized', ...
      'Position',[0.05 0.05 0.70 0.80], ...
      'Visible','off', ...
      'NextPlot','add');
   set(gca,'YDir','reverse');
   load('RectWave.mat','rectwave1');
   image(rectwave1);
   axis off;
     
   %===================================
   % Information for all buttons
   top=0.95;
   bottom=0.05;
   labelColor=[0.8 0.8 0.8];
   yInitPos=0.90;
   left=0.70;
   btnWid=0.25;
   btnHt=0.07;
   % Spacing between the button and the next command's label
   spacing=0.02;
   
   %====================================
   % The CONSOLE frame
   frmBorder=0.02;
   frmPos=[left-frmBorder bottom-frmBorder btnWid+2*frmBorder 0.9+2*frmBorder];
   h=uicontrol( ...
      'Style','frame', ...
      'Units','normalized', ...
      'Position',frmPos, ...
      'BackgroundColor',[0.5 0.5 0.5]);
   
   %====================================
   % The RUN button
   btnNumber=1;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='Run';
   cmdStr='run';
   callbackStr='Demo2(''run'');';
   
   % Generic button information
   btnPos=[left yPos-spacing btnWid btnHt];
   runHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   %====================================
   % The m popup button
   btnNumber=2;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='TEmn Mode m=';
   popupStr=str2mat('0','1','2','3');
   RsData=[0; 1; 2; 3];
   
   % Generic button information
   btnPos1=[left yPos-spacing+btnHt/2 btnWid btnHt/2];
   btnPos2=[left yPos-spacing btnWid btnHt/2];
   SourceHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos1, ...
      'String',labelStr);
   popupHndl1=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos2, ...
      'String',popupStr, ...
      'value',2,...
      'UserData',RsData);
   
   %====================================
   % The n popup button
   btnNumber=3;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='TEmn Mode n=';
   popupStr=str2mat('0','1','2','3');
   RsData=[0; 1; 2; 3];
   
   % Generic button information
   btnPos1=[left yPos-spacing+btnHt/2 btnWid btnHt/2];
   btnPos2=[left yPos-spacing btnWid btnHt/2];
   LoadHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos1, ...
      'String',labelStr);
   popupHndl2=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos2, ...
      'String',popupStr, ...
      'Value',2, ...
      'UserData',RsData);
   
   %====================================
   % The TE Mode radio button
   btnNumber=4;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='Transverse Electric(TEmn) Modes';
   callbackStr='Demo2(''mode'');';
   
   % Generic button information
   btnPos=[left yPos-spacing btnWid btnHt];
   PureRHndl=uicontrol( ...
      'Style','radiobutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Value',1, ...
      'Callback',callbackStr);
   
   %====================================
   % The TM Mode radio button
   btnNumber=5;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='Transverse Magnetic(TMmn) Modes';
   callbackStr='Demo2(''mode'');';
   
   % Generic button information
   btnPos=[left yPos-spacing btnWid btnHt];
   PureCHndl=uicontrol( ...
      'Style','radiobutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Value',0, ...
      'Callback',callbackStr);
  
  
   %====================================  
   % The Surface Charge button
   btnNumber=6;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='Surface Charge Distribution';
   callbackStr='Demo2(''charge'');';
   
   % Generic button information
   btnPos=[left yPos-spacing btnWid btnHt];
   formulaHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left yPos-spacing btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
  

   %====================================  
   % The TE Equation Formula button
   btnNumber=7;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='TE Mode Equation Formula';
   callbackStr='Demo2(''teformula'');';
   
   % Generic button information
   btnPos=[left yPos-spacing btnWid btnHt];
   formulaHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left yPos-spacing btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
   %====================================  
   % The TM Equation Formula button
   btnNumber=8;
   yPos=top-btnHt-(btnNumber-1)*(btnHt+spacing);
   labelStr='TM Mode Equation Formula';
   callbackStr='Demo2(''tmformula'');';
   
   % Generic button information
   btnPos=[left yPos-spacing btnWid btnHt];
   formulaHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left yPos-spacing btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
  
  %====================================
   % The INFO button
   labelStr='Info';
   callbackStr='Demo2(''info'')';
   infoHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom+btnHt+spacing btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   %====================================
   % The CLOSE button
   labelStr='Close';
   callbackStr='close(gcf)';
   closeHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[left bottom btnWid btnHt], ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   % Uncover the figure
   hndlList=[popupHndl1 popupHndl2 PureRHndl PureCHndl SourceHndl LoadHndl];
   set(figNumber, ...
      'Visible','on', ...
      'UserData',hndlList);
   watchoff(oldfigNumber);
   figure(figNumber);
   
elseif strcmp(action,'run'),
   %====================================
   axHndl=gca;
   figNumber=watchon;
   hndlList=get(figNumber,'Userdata');
   popupHndl1=hndlList(1);
   popupHndl2=hndlList(2);
   PureRHndl=hndlList(3);
   PureCHndl=hndlList(4);
   SourceHndl=hndlList(5);
   LoadHndl=hndlList(6);
   
   % ====== Start of Demo
   Re1Value=get(popupHndl1,'Value');
   Re2Value=get(popupHndl2,'Value');
   Re1Matrix=get(popupHndl1,'UserData');
   Re2Matrix=get(popupHndl2,'UserData');
   Re1=Re1Matrix(Re1Value,:);
   Re2=Re2Matrix(Re2Value,:);
   modetype=get(PureRHndl,'Value');
   if modetype==1
       Retype=1;
   else
       Retype=2;
   end
   TEMdraw(Re1,Re2,Retype);
   
   % ====== End of Demo
   watchoff(figNumber);
   
elseif strcmp(action,'mode'),
   axHndl=gca;
   figNumber=watchon;
   drawnow;
   hndlList=get(figNumber,'Userdata');
   popupHndl1=hndlList(1);
   popupHndl2=hndlList(2);
   PureRHndl=hndlList(3);
   PureCHndl=hndlList(4);
   SourceHndl=hndlList(5);
   LoadHndl=hndlList(6);
   
   switch gco
       
   case PureRHndl,
      set(PureRHndl,'Value',1);
      set(PureCHndl,'Value',0);
      set(SourceHndl,'String','TEmn Mode m=');
      set(LoadHndl,'String','TEmn Mode n=','Visible','on');
      popupStr=str2mat('0','1','2','3');
      RsData=[0; 1; 2; 3];
      set(popupHndl1,'String',popupStr,'UserData',RsData,'Value',2);
      set(popupHndl2,'String',popupStr,'UserData',RsData,'Value',2);
      
  case PureCHndl
      set(PureRHndl,'Value',0);
      set(PureCHndl,'Value',1);
      set(SourceHndl,'String','TMmn Mode m=');
      set(LoadHndl,'String','TMmn Mode n=','Visible','on');
      ZStr1=str2mat('0','1','2','3');
      ZData=[0; 1; 2; 3];
      set(popupHndl1,'String',ZStr1,'UserData',ZData,'Value',2);
      set(popupHndl2,'String',ZStr1,'UserData',ZData,'Value',2);
      
   otherwise
       
   end;
   
   watchoff(figNumber);

elseif strcmp(action,'charge'),
   axHndl=gca;
   figNumber=watchon;
   hndlList=get(figNumber,'Userdata');
   popupHndl1=hndlList(1);
   popupHndl2=hndlList(2);
   PureRHndl=hndlList(3);
   PureCHndl=hndlList(4);
   SourceHndl=hndlList(5);
   LoadHndl=hndlList(6);
   
   % ====== Start of Demo
   Re1Value=get(popupHndl1,'Value');
   Re2Value=get(popupHndl2,'Value');
   Re1Matrix=get(popupHndl1,'UserData');
   Re2Matrix=get(popupHndl2,'UserData');
   Re1=Re1Matrix(Re1Value,:);
   Re2=Re2Matrix(Re2Value,:);
   modetype=get(PureRHndl,'Value');
   if modetype==1
       Retype=1;
   else
       Retype=2;
   end
     
   watchoff(figNumber);
%    Tmode = strvcat(['TE'], ['TM']);
%    helpinfo=strvcat(['In this demonstration we just illustrate'... 
%    ' the surface charge distribution of ', Tmode(Retype,:), num2str(Re1), num2str(Re2), ' Mode.'],[' '],...
%    [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
%    diagHndl=helpdlg(helpinfo,'Information');
%    k = waitforbuttonpress;
   SurCharge(Re1,Re2,Retype);
   
elseif strcmp(action,'teformula'),
   figmovie=figure( ...
   'Name',['Rectangular metal Waveguide Equation Formula'], ...
   'NumberTitle','off', ...
   'Visible','on', ...
   'BackingStore','off');
   set(figmovie,'Position',[1 31 1024 662]);
   load('TEform.mat','teform');
   image(teform);

   axis off;
   helpinfo=strvcat(['Print out for good quality'],...      
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif strcmp(action,'tmformula'),
   figmovie=figure( ...
   'Name',['Rectangular metal Waveguide Equation Formula'], ...
   'NumberTitle','off', ...
   'Visible','on', ...
   'BackingStore','off');
   set(figmovie,'Position',[1 31 1024 662]);
   load('TMform.mat','tmform');
   image(tmform);
   axis off;
   helpinfo=strvcat(['Print out for good quality'],...      
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif strcmp(action,'info'),
   helpinfo=strvcat(['This software is used to illustate the demonstrations'... 
      ' related to 6.013 Electromagnetics and Applications.'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
   diagHndl=helpdlg(helpinfo,'Information');
end;    

%  Restore Format
set(0,'Format',old_format)

function pos=TEMdraw(Re1, Re2, Retype)

helpinfo=strvcat(['The Demo is not ready'... 
      .'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
if nargin==0,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==1,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==2,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==3,
   % Define the constants for plot 
   step=61;
   interval=0.999;
   sx=linspace(0,1,20);
   sy=linspace(0,1,20);
   sv=linspace(1,1,20);
   % Geometry of the rectangular waveguide
   a=1;
   b=1;
   c=1;
   % Mode nmuber m n p
   m=Re1;
   n=Re2;
   p=1;
   % Initial demo time
   t=0;
   % Density of steamline
   density = 0.5*(max(m,n)+1);
   
   % TE mode
   if Retype==1
       
       if m+n==0
           helpinfo=['There is no TE',num2str(m),num2str(n),' Mode'];
           diagHndl=helpdlg(helpinfo,'Error');
       else 
           % Wave numbers
           kx=m*pi/a;
           ky=n*pi/b;
           kz=p*pi/c;
           x1=linspace(0,a,step);
           y1=linspace(0,b,step);
           z=linspace(0,c,step);
           [X1,Y1]=meshgrid(x1,y1);
           % Electric field
           U1=-ky*(cos(kx*X1)).*(sin(ky*Y1));
           V1=kx*(sin(kx*X1)).*(cos(ky*Y1));
           W1=0;
           Emag = sqrt(U1.^2 + V1.^2 + W1.^2);
           % Magnetic field
           U2=-kx*(sin(kx*X1)).*(cos(ky*Y1));
           V2=-ky*(cos(kx*X1)).*(sin(ky*Y1));
           W2=(cos(kx*X1)).*(cos(ky*Y1));
           Mmag = sqrt(U2.^2 + V2.^2 + W2.^2);
           % Draw the pattern
           figmovie=figure( ...
               'Name',['Rectangular Metal Waveguide TE',num2str(m),num2str(n),' Mode'], ...
               'NumberTitle','off', ...
               'Visible','on', ...
               'BackingStore','off');
           set(figmovie,'Position',[242 183 600 400]);
           axis([0 a 0 b]);
           hold on;
           box on;
           xlabel('x/a');
           ylabel('y/b');
           legend;
           title(['Rectangular Metal Waveguide TE',num2str(m),num2str(n),' Mode. E(red) H(blue)']);
           h1 = streamslice(X1,Y1,U1,V1,density,'cubic');
           set(h1,'color','r');
           h2 = streamslice(X1,Y1,U2,V2,density,'cubic');
           set(h2,'color','b','Linestyle','--');
           % Draw the seperate line
           for i=1:2*m-1
               plot(i*sv/(2*m),sy,'-.k');
           end
           
           for j=1:2*n-1
               plot(sx,j*sv/(2*n),'-.k');
           end
           
       end
       
   % TM Mode    
   else
       
       if m*n==0
           helpinfo=['There is no TM',num2str(m),num2str(n),' Mode'];
           diagHndl=helpdlg(helpinfo,'Error');
       else
           kx=m*pi/a;
           ky=n*pi/b;
           kz=p*pi/c;
           x1=linspace(0,a,step);
           y1=linspace(0,b,step);
           z=linspace(0,c,step);
           [X1,Y1]=meshgrid(x1,y1);
           % Electric field
           U1=kx*(cos(kx*X1)).*(sin(ky*Y1));
           V1=ky*(sin(kx*X1)).*(cos(ky*Y1));
           W1=(sin(kx*X1)).*(sin(ky*Y1));
           Emag = sqrt(U1.^2 + V1.^2 + W1.^2);
           % Magnetic field
           U2=-ky*(sin(kx*X1)).*(cos(ky*Y1));
           V2=kx*(cos(kx*X1)).*(sin(ky*Y1));
           W2=0;
           Mmag = sqrt(U2.^2 + V2.^2 + W2.^2);
           % Draw the pattern
           figmovie=figure( ...
               'Name',['Rectangular Metal Waveguide TM',num2str(m),num2str(n),' Mode'], ...
               'NumberTitle','off', ...
               'Visible','on', ...
               'BackingStore','off');
           set(figmovie,'Position',[242 183 600 400]);
           axis([0 a 0 b]);
           hold on;
           box on;
           xlabel('x/a');
           ylabel('y/b');
           legend;
           title(['Rectangular Metal Waveguide TM',num2str(m),num2str(n),' Mode. E(red) H(blue)']);
           h1 = streamslice(X1,Y1,U1,V1,density,'cubic');
           set(h1,'color','r');
           h2 = streamslice(X1,Y1,U2,V2,density,'cubic');
           set(h2,'color','b','Linestyle','--');
           
           for i=1:2*m-1
               plot(i*sv/(2*m),sy,'-.k');
           end
           
           for j=1:2*n-1
               plot(sx,j*sv/(2*n),'-.k');
           end
           
       end
       
   end
   
end