function [ output_args ] = dipoleE( Ftype, display, em, emt )
%DIPOLEE Summary of this function goes here
%  Detailed explanation goes here
%  E0=-I*dl*k^2/(4*pi)*sqrt(mu/epsilon);
%  Er=Re(E0*(2*cos(theta)*(1/(j*k*r)^2+1/(j*k*r)^3))*exp(-j*k*r));
%  Etheta=Re(E0*(sin(theta)*(1/(j*k*r)+1/(j*k*r)^2+1/(j*k*r)^3))*exp(-j*k*r));
EMstr=strvcat(['Electric'],['Magnetic']);
helpinfo=strvcat(['The Demo is not ready'... 
      .'],[' '],...
      [' '],[' @2004 Xiaowei He & Markus Zahn. All Rights Reserved.']);
  
if nargin==0,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==1,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==2,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==3,
   diagHndl=helpdlg(helpinfo,'Information');
   
elseif nargin==4,
	figNumber=figure( ...
      'Name',['Point ', EMstr(emt,:), ' Dipole Radiation Demo'], ...
      'NumberTitle','off', ...
      'Visible','on', ...
      'BackingStore','off');
	set(figNumber,'Position',[100,100,810,740]);
	axes( ...
      'Units','normalized', ...
      'Visible','off', ...
      'NextPlot','add');
	set(figNumber,'Menubar','none');
	set(gca,'YDir','reverse');
	axis on;
    set(gca,'XTick', [], 'YTick', []);
	xlabel('Z');
	ylabel('Y');
	title([EMstr(em,:),' field of a point dipole']);
	axis([-1,1,-1,1]);
    
    hold off;
	box on;
    
	view(90,90);
    edensity = 3;    
	E0=-1; % Electric field value
    kfield=[2,5,10]; % Field view type
    DisplaySpeed=[13,25]; % Total number of frames for fast and slow display
	k=kfield(Ftype);
	omega=2*pi;
	m=40; % Number of point on x y axial
	K=horzcat(linspace(-1,-0.05,m),linspace(0.05,1,m));
	[X,Y] = meshgrid(K,K);
	[theta,r] = cart2pol(X,Y);
	th = pi/2-theta;
	time = linspace(0,1,DisplaySpeed(display));
	[j,n] = size(time);
	M = moviein(n); 
    
	for i=1:n
        cla;
        t=time(i);
		Er=-E0*2*cos(th).*(cos(omega*t-k*r)./(k*r).^2+sin(omega*t-k*r)./(k*r).^3);
		Eth=E0*sin(th).*(sin(omega*t-k*r)./(k*r)-cos(omega*t-k*r)./(k*r).^2-sin(omega*t-k*r)./(k*r).^3);
		Ex=cos(th).*Er-sin(th).*Eth;
		Ey=sin(th).*Er+cos(th).*Eth;
%         Hphi=E0*sin(th).*(sin(omega*t-k*r)./(k*r)-cos(omega*t-k*r)./(k*r).^2);
%         Hx=-sin(th).*Hphi;
% 		Hy=+cos(th).*Hphi;
%         subplot(1,2,1);
		h1 = streamslice(X,Y,Ex,Ey,edensity,'cubic');
        set(h1,'color','k');
        title([EMstr(em,:),' field of a point dipole at \omegat = ',num2str(360*t),' degree']);
%         subplot(1,2,2);
%         h2 = streamslice(X,Y,Hx,Hy,2,'cubic');
%         set(h2,'color','k');
        M(:,i) = getframe(gcf);        
	end
    
end