% IAP 2006 Introduction to MATLAB
% Graphics

% EXAMPLE 3 Helix Animation
% A Helix is a 3D curve, described by coordinates:
% x = a*cos(t); y = a*sin(t); z = b*t

% A. Create an animated plot in the Figure Window

% A1. Set the attribute DoubleBuffer of the current figure to On
% so that the plot does not flicker during animation.
set(gcf, 'DoubleBuffer', 'on')

% A2. Define the range of t, and the coefficients a and b.
t = [0 : 0.02*pi : 6*pi];
a = 2; b = 1;

% A3. Draw the Helix in 3D, redrawing the plot after adding every point.
set(gcf, 'Name', 'Helix Animation')

for i=1:length(t)
    
   plot3(a*cos(t(i)), a*sin(t(i)), b*t(i), 'ro');
   hold on
   % Set the axes to be the same during plotting
   set(gca, 'XLim', [-2 2], 'YLim', [-2 2], 'ZLim', [0 20])
   drawnow
   
   % Save the frame in a matrix M to play later - see part B.
   M(i) = getframe(gcf);
   
end
hold off

% A4. See animation in MATLAB 
% Run this file by typing in the Command Window (uncommented)
% << example3

% A5. Comment lines 24 (hold on) and 33 (hold off), and run the file again.
% What happens?

% A6. Play the animation saved in M in MATLAB
% Try the command below (uncommented) in the Command Window:
% movie(gcf, M, 1, 30)
% The animation in the Figure window plays once at 30 frames per second.

% B. Save the animation to play outside of MATLAB
% B1. Save the animation i.e. M in an AVI file
% THIS MAY TAKE SOME TIME. Uncomment this line and execute it ONLY if you
% have enough space for the AVI file to be created: about 212 MB!

% movie2avi(M, 'helix.avi', 'fps', 30, 'quality', 100);

% The helix.avi file is done when you see the MATLAB prompt << again. 

% B2. Play the saved file helix.avi in a movie player on your computer.
% This will play fine on Windows.
% On a Mac it may not play in Quicktime Player, since AVI is a Windows format.
% On Mac OS X you can use a program like the VLC Media Player. 
% On Athena, you can use the xanim program:
% athena% add graphics
% athena% xanim helix.avi

% C. Create an animation
% For example, animate the cubic fit curve from Example Two.
% Play the movie file cubic.avi to see how it should look at the end.
% Download cubic.avi only if you have enough space (about 72 MB)
% from http://web.mit.edu/acmath/matlab/IntroMATLAB.
% Also, see the last frame of the movie in the file cubic.tif.

