% Introduction to MATLAB 
% Programming
% CC Violeta Ivanova, MIT Information Services and Technology

% Example One - A Model Fit to Data Points
% This program computes a custom model fit to five points
% and creates an animated plot.

% Create vectors with X, Y coordinates of points
X = [2 3 5 6 8]'
Y = [75 86 82 70 40]'

% Create interval for model fit computations
x = [0 : 0.1 : 10];

% Use the length and zeros functions to create a vector y:
N = length(x);
y = zeros(1, N);

% Alternatively, if x is a matrix, use the size function instead of length:
% [m, n] = size(x)
% y = zeros(m, n)

% Create a plot with the input points
figure
set(gcf, 'Name', 'Model Fit to Points Animation ')

plot (X, Y, 'ro', 'MarkerFaceColor', 'r')
hold on

% Add your own model fit to the plot (animation)

for i = 1 : N
    
   % Compute y(i) with your own model; for example: 
   y(i) = 60 - 30 * cos( pi/3 + x(i) * pi/6);
   
   % Add y(i) to the figure
   p1 = plot(x(i), y(i), 'bo', 'MarkerSize', 4);
   hold on
   
   % Set the axes to be the same during plotting
   set(gca, 'XLim', [0 10], 'YLim', [0 100]);
   drawnow
   
end

hold off