function [X_grid, Y_grid, Z_surf] = loadmesh(filenameX, filenameY, filenameZ) 

% LOADMESH creates three matrices from the data in three text files.
% [X_grid, Y_grid, Z_surf] = LOADPOINTS (FILENAMEX, FILENAMEY, FILENAMEZ) 
% loads data from FILENAMEX, FILENAMEY, and FILENAMEZ and returns three matrices 
% X_grid, Y_grid, Z_surf created from the three files. If the size of the
% three matrices is not the same, LOADMESH prints a warning in the Command Window.
% If LOADMESH is called with more or fewer than three arguments, it returns an error.
% CC Violeta Ivanova, MIT Information Services & Technology.


% A. Load numbers from a text file

disp('Loading mesh data ...');

if nargin == 3
    X_grid = load (filenameX, '-ascii');
    Y_grid = load (filenameY, '-ascii');
    Z_surf = load (filenameZ, '-ascii');

else
    error('Number of arguments should be 3.')
end

% C. Check if X_grid, Y_grid, and Z_surf have the same size

sizeX = size(X_grid); 
sizeY = size(Y_grid);
sizeZ = size(Z_surf);

if  sizeX == sizeY & sizeY == sizeZ
    disp('Three matrices were created from three files.')
    
else
    disp('Warning: the three created matrices have different sizes.')
end

return