% Central_Force_Motion.m
%
% Simple Central Force Motion Example
%
% State vector and state derivative vector:
%
% X  = [ x;              X_dot = [ x_dot;
%        y;                        y_dot;
%        x_dot;                    x_dot_dot;
%        y_dot ]                   y_dot_dot ]
%

% set parameters for the MATLAB integrator ode45
options = odeset('RelTol', 1e-6, 'AbsTol', 1e-6, 'MaxStep', .005);

X0 = [ -1.0;       %initial x position
        0.0;       %initial y position
        0.0;       %initial x velocity
       -1.0];      %initial y velocity
   
tspan = [0, 3];   % starting and ending time

% perform integration
[t, X] = ode45(@getF, tspan, X0, options);

% plot trajectory y vs x
    plot(X(:,1), X(:,2), 'r');
    xlabel('x-position');
    ylabel('y-position');
    title('Trajectory');
    axis([-0.2,1.2,-0.7,0.7]); axis equal;
    grid on;

% plot center of attraction at (0,0)
rectangle('position',[-0.05,-0.05,0.1,0.1],'curvature',[1,1]);

% plot initial position at (-1., 0.)
rectangle('position',[X0(1)-0.01,X0(2)-0.01,0.02,0.02],'curvature',[1,1]);
