function DX = longTimeResponse(t, X)

% Function LONGTIMERESPONSE computes the longitudinal time response of an
% aircraft due to unit input of elevator deflection angle. 
% A handle to function longTimeResponse is passed to the ode45 solver.

% The state space matrices A, B and the elevator deflection angle deltaE
% defined elsewhere. For an F-8 airplane, see script in file f8long.m.

global A B deltaE

for i = 1:4
    DX(i) = A(i,1)*X(1) + A(i,2)*X(2) + A(i,3)*X(3) + A(i,4)*X(4) + B(i)*deltaE;
end

DX = DX';

return