% 16.01 / 16.02 Unified Engineering, Fall 2006
% Introduction to MATLAB: Programming
% Instructor: Violeta Ivanova, MIT Academic Computing, violeta@mit.edu

% EXERCISE 2 Orbital Velocity Computation Program

% An interactive program that uses this script M-file and the function
% ORBITALVELOCITY defined in the function M-file orbitalvelocity.m.
% MATLAB program flow control statements, relational and logical operators,
% editor / debugger, data types, numeric and string operations.

% Add the code to include the Moon in the options below.
% Re and g0 for the Moon are as follows:
% In metric units: Re = 1736 and g0 = 1.615.
% In English units: Re = 1079 and g0 = 5.3.
% YOU HAVE TO ADD YOUR CODE AMONG THE LINES BELOW

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% A. GET INPUT FROM THE COMMAND WINDOW

disp('This program computes circular orbital velocity.')

% A1. Get input about the units for calculation

units = input('What units? E for English or M for metric: ', 's');

if isempty(units)
    units = 'm';
    disp('The program will use default metric units.')

else 
    units = lower(units);
    
    switch units
        case {'m', 'metric'}
            units = 'm';
            disp('The program will use metric units.')
        case {'e', 'english'}
            units = 'e';
            disp('The program will use English units.')
        otherwise 
            error('Unsupported units.')
    end
end

% A2. Get input about the planet 

disp ('1. Earth')
disp ('2. Mars')

planet = input('Which planet: ', 's');

if isempty(planet)
    planet = 'Earth';
    disp('Assuming planet Earth ...')

else 
    planet = lower(planet);
    
    switch planet
        
        case {'1', 'earth'}
            planet = 'Earth';
            if strcmp(units, 'm')
                Re = 6376; g0 = 9.814;
                disp('Computing for planet Earth in metric units ...')
            else
                Re = 3963; g0 = 32.2;
                disp('Computing for planet Earth in English units ...')
            end

        case {'2', 'mars'}
            planet = 'Mars';
            if strcmp(units, 'm')
                Re = 3396; g0 = 3.688;
                disp('Computing for planet Mars in metric units ...')
            else
                Re = 2111; g0 = 12.1;
                disp('Computing for planet Mars in English units ...')
            end
            
        otherwise 
            Re  = input('Enter mean radius of the planet: ');
            g0 = input('Enter gravitational constant of the planet: ');
            if (Re <= 0 || g0 <= 0)
                error('Impossible values for Re or g0.')
            end
    end
end

% A3. Get input about the altitude H

altitude = input('What altitude above the planet: ');

% B. COMPUTE THE ORBITAL VELOCITY

V = orbitalvelocity(Re, g0, altitude, units);


